/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.extension;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.core.extension.CoreExtension;
import org.sonar.core.extension.CoreExtensionRepository;

public class CoreExtensionRepositoryImpl
implements CoreExtensionRepository {
    private Set<CoreExtension> coreExtensions = null;
    private Set<CoreExtension> installedCoreExtensions = null;

    @Override
    public void setLoadedCoreExtensions(Set<CoreExtension> coreExtensions) {
        Preconditions.checkState((this.coreExtensions == null ? 1 : 0) != 0, (Object)"Repository has already been initialized");
        this.coreExtensions = ImmutableSet.copyOf(coreExtensions);
        this.installedCoreExtensions = new HashSet<CoreExtension>(coreExtensions.size());
    }

    @Override
    public Stream<CoreExtension> loadedCoreExtensions() {
        this.checkInitialized();
        return this.coreExtensions.stream();
    }

    @Override
    public void installed(CoreExtension coreExtension) {
        this.checkInitialized();
        Objects.requireNonNull(coreExtension, "coreExtension can't be null");
        Preconditions.checkArgument((boolean)this.coreExtensions.contains(coreExtension), (Object)"Specified CoreExtension has not been loaded first");
        this.installedCoreExtensions.add(coreExtension);
    }

    @Override
    public boolean isInstalled(String coreExtensionName) {
        this.checkInitialized();
        return this.installedCoreExtensions.stream().anyMatch(t -> coreExtensionName.equals(t.getName()));
    }

    private void checkInitialized() {
        Preconditions.checkState((this.coreExtensions != null ? 1 : 0) != 0, (Object)"Repository has not been initialized yet");
    }
}

