/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.i18n;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.Plugin;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginRepository;

class I18nClassloader
extends URLClassLoader {
    private final ClassLoader[] pluginClassloaders;

    public I18nClassloader(PluginRepository pluginRepository) {
        this(I18nClassloader.allPluginClassloaders(pluginRepository));
    }

    @VisibleForTesting
    I18nClassloader(List<ClassLoader> pluginClassloaders) {
        super(new URL[0]);
        this.pluginClassloaders = pluginClassloaders.toArray(new ClassLoader[pluginClassloaders.size()]);
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader pluginClassloader : this.pluginClassloaders) {
            URL url = pluginClassloader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return this.getClass().getClassLoader().getResource(name);
    }

    protected synchronized Class loadClass(String s, boolean b) throws ClassNotFoundException {
        throw new UnsupportedOperationException("I18n classloader does support only resources, but not classes");
    }

    public String toString() {
        return "i18n-classloader";
    }

    private static List<ClassLoader> allPluginClassloaders(PluginRepository pluginRepository) {
        ArrayList list = Lists.newArrayList();
        for (PluginInfo info : pluginRepository.getPluginInfos()) {
            Plugin plugin = pluginRepository.getPluginInstance(info.getKey());
            list.add(plugin.getClass().getClassLoader());
        }
        list.add(I18nClassloader.class.getClassLoader());
        return list;
    }
}

