/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.platform;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.core.util.UuidFactory;

@Immutable
public final class ServerId {
    public static final char SPLIT_CHARACTER = '-';
    public static final int DATABASE_ID_LENGTH = 8;
    public static final int DEPRECATED_SERVER_ID_LENGTH = 14;
    public static final int NOT_UUID_DATASET_ID_LENGTH = 15;
    public static final int UUID_DATASET_ID_LENGTH = 20;
    private static final Set<Integer> ALLOWED_LENGTHS = ImmutableSet.of((Object)14, (Object)15, (Object)24, (Object)20, (Object)29);
    private final String databaseId;
    private final String datasetId;
    private final Format format;

    private ServerId(@Nullable String databaseId, String datasetId) {
        this.databaseId = databaseId;
        this.datasetId = datasetId;
        this.format = ServerId.computeFormat(databaseId, datasetId);
    }

    public Optional<String> getDatabaseId() {
        return Optional.ofNullable(this.databaseId);
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public Format getFormat() {
        return this.format;
    }

    private static Format computeFormat(@Nullable String databaseId, String datasetId) {
        if (databaseId != null) {
            return Format.WITH_DATABASE_ID;
        }
        if (ServerId.isDate(datasetId)) {
            return Format.DEPRECATED;
        }
        return Format.NO_DATABASE_ID;
    }

    public static ServerId parse(String serverId) {
        String trimmed = serverId.trim();
        int length = trimmed.length();
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"serverId can't be empty");
        Preconditions.checkArgument((boolean)ALLOWED_LENGTHS.contains(length), (Object)"serverId does not have a supported length");
        if (length == 14 || length == 20 || length == 15) {
            return new ServerId(null, trimmed);
        }
        int splitCharIndex = trimmed.indexOf(45);
        if (splitCharIndex == -1) {
            return new ServerId(null, trimmed);
        }
        Preconditions.checkArgument((splitCharIndex == 8 ? 1 : 0) != 0, (Object)"Unrecognized serverId format. Parts have wrong length");
        return ServerId.of(trimmed.substring(0, splitCharIndex), trimmed.substring(splitCharIndex + 1));
    }

    public static ServerId of(@Nullable String databaseId, String datasetId) {
        int datasetIdLength;
        if (databaseId != null) {
            int databaseIdLength = databaseId.length();
            Preconditions.checkArgument((databaseIdLength == 8 ? 1 : 0) != 0, (String)"Illegal databaseId length (%s)", (Object[])new Object[]{databaseIdLength});
        }
        Preconditions.checkArgument(((datasetIdLength = datasetId.length()) == 14 || datasetIdLength == 15 || datasetIdLength == 20 ? 1 : 0) != 0, (String)"Illegal datasetId length (%s)", (Object[])new Object[]{datasetIdLength});
        return new ServerId(databaseId, datasetId);
    }

    public static ServerId create(UuidFactory uuidFactory) {
        return new ServerId(null, uuidFactory.create());
    }

    private static boolean isDate(String value) {
        try {
            new SimpleDateFormat("yyyyMMddHHmmss").parse(value);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public String toString() {
        if (this.databaseId == null) {
            return this.datasetId;
        }
        return this.databaseId + '-' + this.datasetId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerId serverId = (ServerId)o;
        return Objects.equals(this.databaseId, serverId.databaseId) && Objects.equals(this.datasetId, serverId.datasetId);
    }

    public int hashCode() {
        return Objects.hash(this.databaseId, this.datasetId);
    }

    public static enum Format {
        DEPRECATED,
        NO_DATABASE_ID,
        WITH_DATABASE_ID;

    }
}

