/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.ArrayUtils;

public abstract class CloseableIterator<O>
implements Iterator<O>,
AutoCloseable {
    private O nextObject = null;
    boolean isClosed = false;
    private static final CloseableIterator<?> EMPTY_CLOSEABLE_ITERATOR = new CloseableIterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        protected Object doNext() {
            throw new NoSuchElementException("Empty closeable Iterator has no element");
        }

        @Override
        protected void doClose() {
        }
    };

    public static <T> CloseableIterator<T> emptyCloseableIterator() {
        return EMPTY_CLOSEABLE_ITERATOR;
    }

    public static <T> CloseableIterator<T> from(Iterator<T> iterator) {
        Objects.requireNonNull(iterator);
        Preconditions.checkArgument((!(iterator instanceof AutoCloseable) ? 1 : 0) != 0, (Object)"This method does not support creating a CloseableIterator from an Iterator which is Closeable");
        return new RegularIteratorWrapper<T>(iterator);
    }

    public static <T> CloseableIterator<T> wrap(CloseableIterator<T> iterator, AutoCloseable ... otherCloseables) {
        return new CloseablesIteratorWrapper((CloseableIterator)iterator, otherCloseables);
    }

    @Override
    public boolean hasNext() {
        boolean hasNext;
        if (this.isClosed) {
            return false;
        }
        boolean bl = hasNext = this.nextObject != null || this.bufferNext() != null;
        if (!hasNext) {
            this.close();
        }
        return hasNext;
    }

    private O bufferNext() {
        try {
            this.nextObject = this.doNext();
            return this.nextObject;
        }
        catch (RuntimeException e) {
            this.close();
            throw e;
        }
    }

    @CheckForNull
    protected abstract O doNext();

    @Override
    public O next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        O result = this.nextObject;
        this.nextObject = null;
        return result;
    }

    @Override
    public final void remove() {
        try {
            this.doRemove();
        }
        catch (RuntimeException e) {
            this.close();
            throw e;
        }
    }

    protected void doRemove() {
        throw new UnsupportedOperationException("remove() is not supported by default. Override doRemove() if needed.");
    }

    @Override
    public final void close() {
        try {
            this.doClose();
            this.isClosed = true;
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    protected abstract void doClose() throws Exception;

    private static class CloseablesIteratorWrapper<T>
    extends CloseableIterator<T> {
        private final CloseableIterator<T> iterator;
        private final List<AutoCloseable> otherCloseables;

        private CloseablesIteratorWrapper(CloseableIterator<T> iterator, AutoCloseable ... otherCloseables) {
            Objects.requireNonNull(iterator);
            Preconditions.checkArgument((!ArrayUtils.contains((Object[])otherCloseables, iterator) ? 1 : 0) != 0);
            this.iterator = iterator;
            this.otherCloseables = ImmutableList.copyOf((Object[])otherCloseables);
        }

        @Override
        protected T doNext() {
            return this.iterator.hasNext() ? (T)this.iterator.next() : null;
        }

        @Override
        protected void doClose() throws Exception {
            this.iterator.close();
            for (AutoCloseable otherCloseable : this.otherCloseables) {
                otherCloseable.close();
            }
        }
    }

    private static class RegularIteratorWrapper<T>
    extends CloseableIterator<T> {
        private final Iterator<T> iterator;

        public RegularIteratorWrapper(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        protected T doNext() {
            throw new UnsupportedOperationException("hasNext has been override, doNext is never called");
        }

        @Override
        protected void doClose() {
        }
    }
}

