/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util.logs;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.LoggerLevel;
import org.sonar.core.util.logs.Profiler;

class DefaultProfiler
extends Profiler {
    private static final String CONTEXT_SEPARATOR = " | ";
    private static final String NO_MESSAGE_SUFFIX = "";
    private final LinkedHashMap<String, Object> context = new LinkedHashMap();
    private final Logger logger;
    private long startTime = 0L;
    private String startMessage = null;
    private Object[] args = null;
    private boolean logTimeLast = false;

    public DefaultProfiler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public Profiler start() {
        this.startTime = System2.INSTANCE.now();
        this.startMessage = null;
        return this;
    }

    @Override
    public Profiler startTrace(String message) {
        return this.doStart(LoggerLevel.TRACE, message, new Object[0]);
    }

    @Override
    public Profiler startTrace(String message, Object ... args) {
        return this.doStart(LoggerLevel.TRACE, message, args);
    }

    @Override
    public Profiler startDebug(String message) {
        return this.doStart(LoggerLevel.DEBUG, message, new Object[0]);
    }

    @Override
    public Profiler startDebug(String message, Object ... args) {
        return this.doStart(LoggerLevel.DEBUG, message, args);
    }

    @Override
    public Profiler startInfo(String message) {
        return this.doStart(LoggerLevel.INFO, message, new Object[0]);
    }

    @Override
    public Profiler startInfo(String message, Object ... args) {
        return this.doStart(LoggerLevel.INFO, message, args);
    }

    @Override
    public long stopTrace() {
        return this.doStopWithoutMessage(LoggerLevel.TRACE);
    }

    @Override
    public long stopDebug() {
        return this.doStopWithoutMessage(LoggerLevel.DEBUG);
    }

    @Override
    public long stopInfo() {
        return this.doStopWithoutMessage(LoggerLevel.INFO);
    }

    @Override
    public long stopTrace(String message) {
        return this.doStop(LoggerLevel.TRACE, message, null, NO_MESSAGE_SUFFIX);
    }

    @Override
    public long stopTrace(String message, Object ... args) {
        return this.doStop(LoggerLevel.TRACE, message, args, NO_MESSAGE_SUFFIX);
    }

    @Override
    public long stopDebug(String message) {
        return this.doStop(LoggerLevel.DEBUG, message, null, NO_MESSAGE_SUFFIX);
    }

    @Override
    public long stopDebug(String message, Object ... args) {
        return this.doStop(LoggerLevel.DEBUG, message, args, NO_MESSAGE_SUFFIX);
    }

    @Override
    public long stopInfo(String message) {
        return this.doStop(LoggerLevel.INFO, message, null, NO_MESSAGE_SUFFIX);
    }

    @Override
    public long stopInfo(String message, Object ... args) {
        return this.doStop(LoggerLevel.INFO, message, args, NO_MESSAGE_SUFFIX);
    }

    @Override
    public long stopError(String message, Object ... args) {
        return this.doStop(LoggerLevel.ERROR, message, args, NO_MESSAGE_SUFFIX);
    }

    private Profiler doStart(LoggerLevel logLevel, String message, Object ... args) {
        this.init(message, args);
        this.logStartMessage(logLevel, message, args);
        return this;
    }

    private void init(String message, Object ... args) {
        this.startTime = System2.INSTANCE.now();
        this.startMessage = message;
        this.args = args;
    }

    private void reset() {
        this.startTime = 0L;
        this.startMessage = null;
        this.args = null;
        this.context.clear();
    }

    private void logStartMessage(LoggerLevel loggerLevel, String message, Object ... args) {
        if (DefaultProfiler.shouldLog(this.logger, loggerLevel)) {
            StringBuilder sb = new StringBuilder();
            sb.append(message);
            this.appendContext(sb);
            this.log(loggerLevel, sb.toString(), args);
        }
    }

    private long doStopWithoutMessage(LoggerLevel level) {
        if (this.startMessage == null) {
            throw new IllegalStateException("Profiler#stopXXX() can't be called without any message defined in start methods");
        }
        return this.doStop(level, this.startMessage, this.args, " (done)");
    }

    private long doStop(LoggerLevel level, @Nullable String message, @Nullable Object[] args, String messageSuffix) {
        if (this.startTime == 0L) {
            throw new IllegalStateException("Profiler must be started before being stopped");
        }
        long duration = System2.INSTANCE.now() - this.startTime;
        if (DefaultProfiler.shouldLog(this.logger, level)) {
            StringBuilder sb = new StringBuilder();
            if (!StringUtils.isEmpty((String)message)) {
                sb.append(message);
                sb.append(messageSuffix);
            }
            if (this.logTimeLast) {
                this.appendContext(sb);
                DefaultProfiler.appendTime(sb, duration);
            } else {
                DefaultProfiler.appendTime(sb, duration);
                this.appendContext(sb);
            }
            this.log(level, sb.toString(), args);
        }
        this.reset();
        return duration;
    }

    private static void appendTime(StringBuilder sb, long duration) {
        if (sb.length() > 0) {
            sb.append(CONTEXT_SEPARATOR);
        }
        sb.append("time=").append(duration).append("ms");
    }

    private void appendContext(StringBuilder sb) {
        for (Map.Entry<String, Object> entry : this.context.entrySet()) {
            if (sb.length() > 0) {
                sb.append(CONTEXT_SEPARATOR);
            }
            sb.append(entry.getKey()).append("=").append(Objects.toString(entry.getValue()));
        }
    }

    void log(LoggerLevel level, String msg, @Nullable Object[] args) {
        switch (level) {
            case TRACE: {
                this.logTrace(msg, args);
                break;
            }
            case DEBUG: {
                this.logDebug(msg, args);
                break;
            }
            case INFO: {
                this.logInfo(msg, args);
                break;
            }
            case WARN: {
                this.logWarn(msg, args);
                break;
            }
            case ERROR: {
                this.logError(msg, args);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported LoggerLevel value: " + level);
            }
        }
    }

    private void logTrace(String msg, @Nullable Object[] args) {
        if (args == null) {
            this.logger.trace(msg);
        } else {
            this.logger.trace(msg, args);
        }
    }

    private void logDebug(String msg, @Nullable Object[] args) {
        if (args == null) {
            this.logger.debug(msg);
        } else {
            this.logger.debug(msg, args);
        }
    }

    private void logInfo(String msg, @Nullable Object[] args) {
        if (args == null) {
            this.logger.info(msg);
        } else {
            this.logger.info(msg, args);
        }
    }

    private void logWarn(String msg, @Nullable Object[] args) {
        if (args == null) {
            this.logger.warn(msg);
        } else {
            this.logger.warn(msg, args);
        }
    }

    private void logError(String msg, @Nullable Object[] args) {
        if (args == null) {
            this.logger.error(msg);
        } else {
            this.logger.error(msg, args);
        }
    }

    private static boolean shouldLog(Logger logger, LoggerLevel level) {
        if (level == LoggerLevel.TRACE && !logger.isTraceEnabled()) {
            return false;
        }
        return level != LoggerLevel.DEBUG || logger.isDebugEnabled();
    }

    @Override
    public Profiler addContext(String key, @Nullable Object value) {
        if (value == null) {
            this.context.remove(key);
        } else {
            this.context.put(key, value);
        }
        return this;
    }

    @Override
    public boolean hasContext(String key) {
        return this.context.containsKey(key);
    }

    @Override
    public Profiler logTimeLast(boolean flag) {
        this.logTimeLast = flag;
        return this;
    }
}

