/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public final class MediaTypes {
    public static final String JSON = "application/json";
    public static final String XML = "application/xml";
    public static final String TXT = "text/plain";
    public static final String PROTOBUF = "application/x-protobuf";
    public static final String ZIP = "application/zip";
    public static final String JAVASCRIPT = "application/javascript";
    public static final String HTML = "text/html";
    public static final String DEFAULT = "application/octet-stream";
    public static final String SVG = "image/svg+xml";
    private static final Map<String, String> MAP = new ImmutableMap.Builder().put((Object)"js", (Object)"application/javascript").put((Object)"json", (Object)"application/json").put((Object)"zip", (Object)"application/zip").put((Object)"tgz", (Object)"application/tgz").put((Object)"ps", (Object)"application/postscript").put((Object)"jnlp", (Object)"application/jnlp").put((Object)"jar", (Object)"application/java-archive").put((Object)"xls", (Object)"application/vnd.ms-excel").put((Object)"ppt", (Object)"application/vnd.ms-powerpoint").put((Object)"tar", (Object)"application/x-tar").put((Object)"xml", (Object)"application/xml").put((Object)"dtd", (Object)"application/xml-dtd").put((Object)"xslt", (Object)"application/xslt+xml").put((Object)"bmp", (Object)"image/bmp").put((Object)"gif", (Object)"image/gif").put((Object)"jpg", (Object)"image/jpeg").put((Object)"jpeg", (Object)"image/jpeg").put((Object)"tiff", (Object)"image/tiff").put((Object)"png", (Object)"image/png").put((Object)"svg", (Object)"image/svg+xml").put((Object)"ico", (Object)"image/x-icon").put((Object)"txt", (Object)"text/plain").put((Object)"csv", (Object)"text/csv").put((Object)"properties", (Object)"text/plain").put((Object)"rtf", (Object)"text/rtf").put((Object)"html", (Object)"text/html").put((Object)"css", (Object)"text/css").put((Object)"tsv", (Object)"text/tab-separated-values").build();

    private MediaTypes() {
    }

    public static String getByFilename(String filename) {
        String extension = FilenameUtils.getExtension((String)filename);
        String mime = null;
        if (!Strings.isNullOrEmpty((String)extension)) {
            mime = MAP.get(extension.toLowerCase(Locale.ENGLISH));
        }
        return mime != null ? mime : DEFAULT;
    }
}

