/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application;

import java.io.IOException;
import org.sonar.application.AppFileSystem;
import org.sonar.application.AppLogging;
import org.sonar.application.AppReloaderImpl;
import org.sonar.application.AppState;
import org.sonar.application.AppStateFactory;
import org.sonar.application.Scheduler;
import org.sonar.application.SchedulerImpl;
import org.sonar.application.command.CommandFactoryImpl;
import org.sonar.application.config.AppSettings;
import org.sonar.application.config.AppSettingsLoaderImpl;
import org.sonar.application.config.SonarQubeVersionHelper;
import org.sonar.application.process.ProcessLauncherImpl;
import org.sonar.application.process.StopRequestWatcher;
import org.sonar.application.process.StopRequestWatcherImpl;
import org.sonar.process.ProcessProperties;
import org.sonar.process.System2;
import org.sonar.process.SystemExit;

public class App {
    private final SystemExit systemExit = new SystemExit();
    private StopRequestWatcher stopRequestWatcher;

    public void start(String[] cliArguments) throws IOException {
        AppSettingsLoaderImpl settingsLoader = new AppSettingsLoaderImpl(cliArguments);
        AppSettings settings = settingsLoader.load();
        AppLogging logging = new AppLogging(settings);
        logging.configure();
        AppFileSystem fileSystem = new AppFileSystem(settings);
        try (AppState appState = new AppStateFactory(settings).create();){
            appState.registerSonarQubeVersion(SonarQubeVersionHelper.getSonarqubeVersion());
            appState.registerClusterName(settings.getProps().nonNullValue(ProcessProperties.Property.CLUSTER_NAME.getKey()));
            AppReloaderImpl appReloader = new AppReloaderImpl(settingsLoader, fileSystem, appState, logging);
            fileSystem.reset();
            CommandFactoryImpl commandFactory = new CommandFactoryImpl(settings.getProps(), fileSystem.getTempDir(), System2.INSTANCE);
            try (ProcessLauncherImpl processLauncher = new ProcessLauncherImpl(fileSystem.getTempDir());){
                SchedulerImpl scheduler = new SchedulerImpl(settings, appReloader, commandFactory, processLauncher, appState);
                Runtime.getRuntime().addShutdownHook(new ShutdownHook(scheduler));
                scheduler.schedule();
                this.stopRequestWatcher = StopRequestWatcherImpl.create(settings, scheduler, fileSystem);
                this.stopRequestWatcher.startWatching();
                scheduler.awaitTermination();
                this.stopRequestWatcher.stopWatching();
            }
        }
        this.systemExit.exit(0);
    }

    public static void main(String ... args) throws IOException {
        new App().start(args);
    }

    private class ShutdownHook
    extends Thread {
        private final Scheduler scheduler;

        public ShutdownHook(Scheduler scheduler) {
            super("SonarQube Shutdown Hook");
            this.scheduler = scheduler;
        }

        @Override
        public void run() {
            App.this.systemExit.setInShutdownHook();
            if (App.this.stopRequestWatcher != null) {
                App.this.stopRequestWatcher.stopWatching();
            }
            this.scheduler.terminate();
        }
    }
}

