/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.application.FileSystem;
import org.sonar.application.config.AppSettings;
import org.sonar.process.FileUtils2;
import org.sonar.process.ProcessProperties;
import org.sonar.process.sharedmemoryfile.AllProcessesCommands;

public class AppFileSystem
implements FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(AppFileSystem.class);
    private static final EnumSet<FileVisitOption> FOLLOW_LINKS = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
    private final AppSettings settings;

    public AppFileSystem(AppSettings settings) {
        this.settings = settings;
    }

    @Override
    public void reset() throws IOException {
        this.createDirectory(ProcessProperties.Property.PATH_DATA.getKey());
        this.createDirectory(ProcessProperties.Property.PATH_WEB.getKey());
        this.createDirectory(ProcessProperties.Property.PATH_LOGS.getKey());
        File tempDir = this.createOrCleanTempDirectory(ProcessProperties.Property.PATH_TEMP.getKey());
        try (AllProcessesCommands allProcessesCommands = new AllProcessesCommands(tempDir);){
            allProcessesCommands.clean();
        }
    }

    @Override
    public File getTempDir() {
        return this.settings.getProps().nonNullValueAsFile(ProcessProperties.Property.PATH_TEMP.getKey());
    }

    private boolean createDirectory(String propKey) throws IOException {
        File dir = this.settings.getProps().nonNullValueAsFile(propKey);
        if (dir.exists()) {
            AppFileSystem.ensureIsNotAFile(propKey, dir);
            return false;
        }
        FileUtils.forceMkdir((File)dir);
        AppFileSystem.ensureIsNotAFile(propKey, dir);
        return true;
    }

    private static void ensureIsNotAFile(String propKey, File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalStateException(String.format("Property '%s' is not valid, not a directory: %s", propKey, dir.getAbsolutePath()));
        }
    }

    private File createOrCleanTempDirectory(String propKey) throws IOException {
        File dir = this.settings.getProps().nonNullValueAsFile(propKey);
        LOG.info("Cleaning or creating temp directory {}", (Object)dir.getAbsolutePath());
        if (!this.createDirectory(propKey)) {
            Files.walkFileTree(dir.toPath(), FOLLOW_LINKS, 1, new CleanTempDirFileVisitor(dir.toPath()));
        }
        return dir;
    }

    private static class CleanTempDirFileVisitor
    extends SimpleFileVisitor<Path> {
        private static final Path SHAREDMEMORY_FILE = Paths.get("sharedmemory", new String[0]);
        static final int VISIT_MAX_DEPTH = 1;
        private final Path path;
        private final boolean symLink;

        CleanTempDirFileVisitor(Path path) {
            this.path = path;
            this.symLink = Files.isSymbolicLink(path);
        }

        @Override
        public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) throws IOException {
            File file = filePath.toFile();
            if (file.isDirectory()) {
                FileUtils2.deleteDirectory((File)file);
            } else {
                if (filePath.getFileName().equals(SHAREDMEMORY_FILE)) {
                    return FileVisitResult.CONTINUE;
                }
                if (!this.symLink || !filePath.equals(this.path)) {
                    Files.delete(filePath);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (!dir.equals(this.path)) {
                FileUtils2.deleteDirectory((File)dir.toFile());
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

