/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.sonar.application.AppState;
import org.sonar.application.AppStateListener;
import org.sonar.process.NetworkUtilsImpl;
import org.sonar.process.ProcessId;

public class AppStateImpl
implements AppState {
    private final Map<ProcessId, Boolean> processes = new EnumMap<ProcessId, Boolean>(ProcessId.class);
    private final List<AppStateListener> listeners = new ArrayList<AppStateListener>();
    private final AtomicBoolean webLeaderLocked = new AtomicBoolean(false);

    @Override
    public void addListener(@Nonnull AppStateListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean isOperational(ProcessId processId, boolean local) {
        return this.processes.computeIfAbsent(processId, p -> false);
    }

    @Override
    public void setOperational(ProcessId processId) {
        this.processes.put(processId, true);
        this.listeners.forEach(l -> l.onAppStateOperational(processId));
    }

    @Override
    public boolean tryToLockWebLeader() {
        return this.webLeaderLocked.compareAndSet(false, true);
    }

    @Override
    public void reset() {
        this.webLeaderLocked.set(false);
        this.processes.clear();
    }

    @Override
    public void registerSonarQubeVersion(String sonarqubeVersion) {
    }

    @Override
    public void registerClusterName(String clusterName) {
    }

    @Override
    public Optional<String> getLeaderHostName() {
        return Optional.of(NetworkUtilsImpl.INSTANCE.getHostname());
    }

    @Override
    public void close() {
    }
}

