/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application;

import java.util.EnumMap;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.application.AppReloader;
import org.sonar.application.AppState;
import org.sonar.application.AppStateListener;
import org.sonar.application.NodeLifecycle;
import org.sonar.application.Scheduler;
import org.sonar.application.command.AbstractCommand;
import org.sonar.application.command.CommandFactory;
import org.sonar.application.config.AppSettings;
import org.sonar.application.config.ClusterSettings;
import org.sonar.application.process.Lifecycle;
import org.sonar.application.process.ProcessEventListener;
import org.sonar.application.process.ProcessLauncher;
import org.sonar.application.process.ProcessLifecycleListener;
import org.sonar.application.process.ProcessMonitor;
import org.sonar.application.process.SQProcess;
import org.sonar.process.ProcessId;

public class SchedulerImpl
implements Scheduler,
ProcessEventListener,
ProcessLifecycleListener,
AppStateListener {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerImpl.class);
    private final AppSettings settings;
    private final AppReloader appReloader;
    private final CommandFactory commandFactory;
    private final ProcessLauncher processLauncher;
    private final AppState appState;
    private final NodeLifecycle nodeLifecycle = new NodeLifecycle();
    private final CountDownLatch keepAlive = new CountDownLatch(1);
    private final AtomicBoolean firstWaitingEsLog = new AtomicBoolean(true);
    private final AtomicBoolean restartRequested = new AtomicBoolean(false);
    private final AtomicBoolean restartDisabled = new AtomicBoolean(false);
    private final EnumMap<ProcessId, SQProcess> processesById = new EnumMap(ProcessId.class);
    private final AtomicInteger operationalCountDown = new AtomicInteger();
    private final AtomicInteger stopCountDown = new AtomicInteger(0);
    private StopperThread stopperThread;
    private RestarterThread restarterThread;
    private long processWatcherDelayMs = 500L;

    public SchedulerImpl(AppSettings settings, AppReloader appReloader, CommandFactory commandFactory, ProcessLauncher processLauncher, AppState appState) {
        this.settings = settings;
        this.appReloader = appReloader;
        this.commandFactory = commandFactory;
        this.processLauncher = processLauncher;
        this.appState = appState;
        this.appState.addListener(this);
    }

    SchedulerImpl setProcessWatcherDelayMs(long l) {
        this.processWatcherDelayMs = l;
        return this;
    }

    @Override
    public void schedule() {
        if (!this.nodeLifecycle.tryToMoveTo(NodeLifecycle.State.STARTING)) {
            return;
        }
        this.processesById.clear();
        for (ProcessId processId : ClusterSettings.getEnabledProcesses(this.settings)) {
            SQProcess process = SQProcess.builder(processId).addProcessLifecycleListener(this).addEventListener(this).setWatcherDelayMs(this.processWatcherDelayMs).build();
            this.processesById.put(process.getProcessId(), process);
        }
        this.operationalCountDown.set(this.processesById.size());
        this.tryToStartAll();
    }

    private void tryToStartAll() {
        this.tryToStartEs();
        this.tryToStartWeb();
        this.tryToStartCe();
    }

    private void tryToStartEs() {
        SQProcess process = this.processesById.get(ProcessId.ELASTICSEARCH);
        if (process != null) {
            this.tryToStartProcess(process, this.commandFactory::createEsCommand);
        }
    }

    private void tryToStartWeb() {
        SQProcess process = this.processesById.get(ProcessId.WEB_SERVER);
        if (process == null) {
            return;
        }
        if (!this.isEsClientStartable()) {
            if (this.firstWaitingEsLog.getAndSet(false)) {
                LOG.info("Waiting for Elasticsearch to be up and running");
            }
            return;
        }
        if (this.appState.isOperational(ProcessId.WEB_SERVER, false)) {
            this.tryToStartProcess(process, () -> this.commandFactory.createWebCommand(false));
        } else if (this.appState.tryToLockWebLeader()) {
            this.tryToStartProcess(process, () -> this.commandFactory.createWebCommand(true));
        } else {
            Optional<String> leader = this.appState.getLeaderHostName();
            if (leader.isPresent()) {
                LOG.info("Waiting for initialization from {}", (Object)leader.get());
            } else {
                LOG.error("Initialization failed. All nodes must be restarted");
            }
        }
    }

    private void tryToStartCe() {
        SQProcess process = this.processesById.get(ProcessId.COMPUTE_ENGINE);
        if (process != null && this.appState.isOperational(ProcessId.WEB_SERVER, true) && this.isEsClientStartable()) {
            this.tryToStartProcess(process, this.commandFactory::createCeCommand);
        }
    }

    private boolean isEsClientStartable() {
        boolean requireLocalEs = ClusterSettings.isLocalElasticsearchEnabled(this.settings);
        return this.appState.isOperational(ProcessId.ELASTICSEARCH, requireLocalEs);
    }

    private void tryToStartProcess(SQProcess process, Supplier<AbstractCommand> commandSupplier) {
        this.tryToStart(process, () -> {
            AbstractCommand command = (AbstractCommand)commandSupplier.get();
            return this.processLauncher.launch(command);
        });
    }

    private void tryToStart(SQProcess process, Supplier<ProcessMonitor> processMonitorSupplier) {
        try {
            process.start(processMonitorSupplier);
        }
        catch (RuntimeException e) {
            this.terminate();
            throw e;
        }
    }

    private void stopAll() {
        this.stopProcess(ProcessId.COMPUTE_ENGINE);
        this.stopProcess(ProcessId.WEB_SERVER);
        this.stopProcess(ProcessId.ELASTICSEARCH);
    }

    private void stopProcess(ProcessId processId) {
        SQProcess process = this.processesById.get(processId);
        if (process != null) {
            process.stop(1L, TimeUnit.MINUTES);
        }
    }

    @Override
    public void terminate() {
        this.restartRequested.set(false);
        this.restartDisabled.set(true);
        if (this.nodeLifecycle.tryToMoveTo(NodeLifecycle.State.STOPPING)) {
            LOG.info("Stopping SonarQube");
        }
        this.stopAll();
        if (this.stopperThread != null) {
            this.stopperThread.interrupt();
        }
        if (this.restarterThread != null) {
            this.restarterThread.interrupt();
        }
        this.keepAlive.countDown();
    }

    @Override
    public void awaitTermination() {
        try {
            this.keepAlive.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void onProcessEvent(ProcessId processId, ProcessEventListener.Type type) {
        if (type == ProcessEventListener.Type.OPERATIONAL) {
            this.onProcessOperational(processId);
        } else if (type == ProcessEventListener.Type.ASK_FOR_RESTART && this.restartRequested.compareAndSet(false, true)) {
            this.stopAsync();
        }
    }

    private void onProcessOperational(ProcessId processId) {
        LOG.info("Process[{}] is up", (Object)processId.getKey());
        this.appState.setOperational(processId);
        if (this.operationalCountDown.decrementAndGet() == 0 && this.nodeLifecycle.tryToMoveTo(NodeLifecycle.State.OPERATIONAL)) {
            LOG.info("SonarQube is up");
        }
    }

    @Override
    public void onAppStateOperational(ProcessId processId) {
        if (this.nodeLifecycle.getState() == NodeLifecycle.State.STARTING) {
            this.tryToStartAll();
        }
    }

    @Override
    public void onProcessState(ProcessId processId, Lifecycle.State to) {
        switch (to) {
            case STOPPED: {
                this.onProcessStop(processId);
                break;
            }
            case STARTING: {
                this.stopCountDown.incrementAndGet();
                break;
            }
        }
    }

    private void onProcessStop(ProcessId processId) {
        LOG.info("Process [{}] is stopped", (Object)processId.getKey());
        if (this.stopCountDown.decrementAndGet() == 0 && this.nodeLifecycle.tryToMoveTo(NodeLifecycle.State.STOPPED)) {
            if (!this.restartDisabled.get() && this.restartRequested.compareAndSet(true, false)) {
                LOG.info("SonarQube is restarting");
                this.restartAsync();
            } else {
                LOG.info("SonarQube is stopped");
                this.terminate();
            }
        } else if (this.nodeLifecycle.tryToMoveTo(NodeLifecycle.State.STOPPING)) {
            this.stopAsync();
        }
    }

    private void stopAsync() {
        this.stopperThread = new StopperThread();
        this.stopperThread.start();
    }

    private void restartAsync() {
        this.restarterThread = new RestarterThread();
        this.restarterThread.start();
    }

    private class StopperThread
    extends Thread {
        public StopperThread() {
            super("Stopper");
        }

        @Override
        public void run() {
            SchedulerImpl.this.stopAll();
        }
    }

    private class RestarterThread
    extends Thread {
        public RestarterThread() {
            super("Restarter");
        }

        @Override
        public void run() {
            try {
                SchedulerImpl.this.appReloader.reload(SchedulerImpl.this.settings);
                SchedulerImpl.this.schedule();
            }
            catch (Exception e) {
                LOG.error("Fail to restart", (Throwable)e);
                SchedulerImpl.this.terminate();
            }
        }
    }
}

