/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.cluster;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.ReplicatedMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.application.AppStateListener;
import org.sonar.application.cluster.ClusterAppState;
import org.sonar.application.cluster.ClusterProcess;
import org.sonar.application.cluster.health.HealthStateSharing;
import org.sonar.application.cluster.health.HealthStateSharingImpl;
import org.sonar.application.cluster.health.SearchNodeHealthProvider;
import org.sonar.application.config.AppSettings;
import org.sonar.application.config.ClusterSettings;
import org.sonar.application.es.EsConnector;
import org.sonar.process.MessageException;
import org.sonar.process.NetworkUtilsImpl;
import org.sonar.process.ProcessId;
import org.sonar.process.cluster.hz.HazelcastMember;

public class ClusterAppStateImpl
implements ClusterAppState {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterAppStateImpl.class);
    private final HazelcastMember hzMember;
    private final List<AppStateListener> listeners = new ArrayList<AppStateListener>();
    private final Map<ProcessId, Boolean> operationalLocalProcesses = new EnumMap<ProcessId, Boolean>(ProcessId.class);
    private final ReplicatedMap<ClusterProcess, Boolean> operationalProcesses;
    private final String operationalProcessListenerUUID;
    private final String nodeDisconnectedListenerUUID;
    private final EsConnector esConnector;
    private HealthStateSharing healthStateSharing = null;

    public ClusterAppStateImpl(AppSettings settings, HazelcastMember hzMember, EsConnector esConnector) {
        this.hzMember = hzMember;
        this.operationalProcesses = (ReplicatedMap)hzMember.getReplicatedMap("OPERATIONAL_PROCESSES");
        this.operationalProcessListenerUUID = this.operationalProcesses.addEntryListener((EntryListener)new OperationalProcessListener());
        this.nodeDisconnectedListenerUUID = hzMember.getCluster().addMembershipListener((MembershipListener)new NodeDisconnectedListener());
        if (ClusterSettings.isLocalElasticsearchEnabled(settings)) {
            this.healthStateSharing = new HealthStateSharingImpl(hzMember, new SearchNodeHealthProvider(settings.getProps(), this, NetworkUtilsImpl.INSTANCE));
            this.healthStateSharing.start();
        }
        this.esConnector = esConnector;
    }

    @Override
    public HazelcastMember getHazelcastMember() {
        return this.hzMember;
    }

    @Override
    public void addListener(AppStateListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean isOperational(ProcessId processId, boolean local) {
        if (local) {
            return this.operationalLocalProcesses.computeIfAbsent(processId, p -> false);
        }
        if (processId.equals((Object)ProcessId.ELASTICSEARCH)) {
            return this.isElasticSearchAvailable();
        }
        for (Map.Entry entry : this.operationalProcesses.entrySet()) {
            if (!((ClusterProcess)entry.getKey()).getProcessId().equals((Object)processId) || !((Boolean)entry.getValue()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setOperational(ProcessId processId) {
        this.operationalLocalProcesses.put(processId, true);
        this.operationalProcesses.put((Object)new ClusterProcess(this.hzMember.getUuid(), processId), (Object)Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryToLockWebLeader() {
        IAtomicReference leader = this.hzMember.getAtomicReference("LEADER");
        if (leader.get() == null) {
            Lock lock = this.hzMember.getLock("LEADER");
            lock.lock();
            try {
                if (leader.get() == null) {
                    leader.set((Object)this.hzMember.getUuid());
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        return false;
    }

    @Override
    public void reset() {
        throw new IllegalStateException("state reset is not supported in cluster mode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSonarQubeVersion(String sonarqubeVersion) {
        IAtomicReference sqVersion = this.hzMember.getAtomicReference("SONARQUBE_VERSION");
        if (sqVersion.get() == null) {
            Lock lock = this.hzMember.getLock("SONARQUBE_VERSION");
            lock.lock();
            try {
                if (sqVersion.get() == null) {
                    sqVersion.set((Object)sonarqubeVersion);
                }
            }
            finally {
                lock.unlock();
            }
        }
        String clusterVersion = (String)sqVersion.get();
        if (!((String)sqVersion.get()).equals(sonarqubeVersion)) {
            throw new IllegalStateException(String.format("The local version %s is not the same as the cluster %s", sonarqubeVersion, clusterVersion));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerClusterName(String clusterName) {
        IAtomicReference property = this.hzMember.getAtomicReference("CLUSTER_NAME");
        if (property.get() == null) {
            Lock lock = this.hzMember.getLock("CLUSTER_NAME");
            lock.lock();
            try {
                if (property.get() == null) {
                    property.set((Object)clusterName);
                }
            }
            finally {
                lock.unlock();
            }
        }
        String clusterValue = (String)property.get();
        if (!((String)property.get()).equals(clusterName)) {
            throw new MessageException(String.format("This node has a cluster name [%s], which does not match [%s] from the cluster", clusterName, clusterValue));
        }
    }

    @Override
    public Optional<String> getLeaderHostName() {
        Optional<Member> leader;
        String leaderId = (String)this.hzMember.getAtomicReference("LEADER").get();
        if (leaderId != null && (leader = this.hzMember.getCluster().getMembers().stream().filter(m -> m.getUuid().equals(leaderId)).findFirst()).isPresent()) {
            return Optional.of(leader.get().getAddress().getHost());
        }
        return Optional.empty();
    }

    @Override
    public void close() {
        this.esConnector.stop();
        if (this.hzMember != null) {
            if (this.healthStateSharing != null) {
                this.healthStateSharing.stop();
            }
            try {
                this.operationalProcesses.removeEntryListener(this.operationalProcessListenerUUID);
                this.hzMember.getCluster().removeMembershipListener(this.nodeDisconnectedListenerUUID);
                this.operationalProcesses.keySet().forEach(clusterNodeProcess -> {
                    if (clusterNodeProcess.getNodeUuid().equals(this.hzMember.getUuid())) {
                        this.operationalProcesses.remove(clusterNodeProcess);
                    }
                });
                this.hzMember.close();
            }
            catch (HazelcastInstanceNotActiveException e) {
                LOGGER.debug("Unable to close Hazelcast cluster", (Throwable)e);
            }
        }
    }

    private boolean isElasticSearchAvailable() {
        ClusterHealthStatus clusterHealthStatus = this.esConnector.getClusterHealthStatus();
        return clusterHealthStatus.equals((Object)ClusterHealthStatus.GREEN) || clusterHealthStatus.equals((Object)ClusterHealthStatus.YELLOW);
    }

    private class NodeDisconnectedListener
    implements MembershipListener {
        private NodeDisconnectedListener() {
        }

        public void memberAdded(MembershipEvent membershipEvent) {
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            this.removeOperationalProcess(membershipEvent.getMember().getUuid());
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
        }

        private void removeOperationalProcess(String uuid) {
            for (ClusterProcess clusterProcess : ClusterAppStateImpl.this.operationalProcesses.keySet()) {
                if (!clusterProcess.getNodeUuid().equals(uuid)) continue;
                LOGGER.debug("Set node process off for [{}:{}] : ", (Object)clusterProcess.getNodeUuid(), (Object)clusterProcess.getProcessId());
                ClusterAppStateImpl.this.hzMember.getReplicatedMap("OPERATIONAL_PROCESSES").put(clusterProcess, Boolean.FALSE);
            }
        }
    }

    private class OperationalProcessListener
    implements EntryListener<ClusterProcess, Boolean> {
        private OperationalProcessListener() {
        }

        public void entryAdded(EntryEvent<ClusterProcess, Boolean> event) {
            if (((Boolean)event.getValue()).booleanValue()) {
                ClusterAppStateImpl.this.listeners.forEach(appStateListener -> appStateListener.onAppStateOperational(((ClusterProcess)event.getKey()).getProcessId()));
            }
        }

        public void entryRemoved(EntryEvent<ClusterProcess, Boolean> event) {
        }

        public void entryUpdated(EntryEvent<ClusterProcess, Boolean> event) {
            if (((Boolean)event.getValue()).booleanValue()) {
                ClusterAppStateImpl.this.listeners.forEach(appStateListener -> appStateListener.onAppStateOperational(((ClusterProcess)event.getKey()).getProcessId()));
            }
        }

        public void entryEvicted(EntryEvent<ClusterProcess, Boolean> event) {
        }

        public void mapCleared(MapEvent event) {
        }

        public void mapEvicted(MapEvent event) {
        }
    }
}

