/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.process.MessageException;
import org.sonar.process.Props;

public class JvmOptions<T extends JvmOptions> {
    private static final String JVM_OPTION_NOT_NULL_ERROR_MESSAGE = "a JVM option can't be null";
    private final HashMap<String, String> mandatoryOptions = new HashMap();
    private final LinkedHashSet<String> options = new LinkedHashSet();

    public JvmOptions() {
        this(Collections.emptyMap());
    }

    public JvmOptions(Map<String, String> mandatoryJvmOptions) {
        Objects.requireNonNull(mandatoryJvmOptions, JVM_OPTION_NOT_NULL_ERROR_MESSAGE).entrySet().stream().filter(e -> {
            Objects.requireNonNull(e.getKey(), "JVM option prefix can't be null");
            if (((String)e.getKey()).trim().isEmpty()) {
                throw new IllegalArgumentException("JVM option prefix can't be empty");
            }
            Objects.requireNonNull(e.getValue(), "JVM option value can't be null");
            return true;
        }).forEach(e -> {
            String key = ((String)e.getKey()).trim();
            String value = ((String)e.getValue()).trim();
            this.mandatoryOptions.put(key, value);
            this.add(key + value);
        });
    }

    public T addFromMandatoryProperty(Props props, String propertyName) {
        String value = props.nonNullValue(propertyName);
        if (!value.isEmpty()) {
            List<String> jvmOptions = Arrays.stream(value.split(" (?=-)")).map(String::trim).collect(Collectors.toList());
            JvmOptions.checkOptionFormat(propertyName, jvmOptions);
            this.checkMandatoryOptionOverwrite(propertyName, jvmOptions);
            this.options.addAll(jvmOptions);
        }
        return this.castThis();
    }

    private static void checkOptionFormat(String propertyName, List<String> jvmOptionsFromProperty) {
        List invalidOptions = jvmOptionsFromProperty.stream().filter(JvmOptions::isInvalidOption).collect(Collectors.toList());
        if (!invalidOptions.isEmpty()) {
            throw new MessageException(String.format("a JVM option can't be empty and must start with '-'. The following JVM options defined by property '%s' are invalid: %s", propertyName, invalidOptions.stream().collect(Collectors.joining(", "))));
        }
    }

    private void checkMandatoryOptionOverwrite(String propertyName, List<String> jvmOptionsFromProperty) {
        List matches = jvmOptionsFromProperty.stream().map(jvmOption -> new Match((String)jvmOption, this.mandatoryOptionFor((String)jvmOption))).filter(match -> match.getMandatoryOption() != null).collect(Collectors.toList());
        if (!matches.isEmpty()) {
            throw new MessageException(String.format("a JVM option can't overwrite mandatory JVM options. The following JVM options defined by property '%s' are invalid: %s", propertyName, matches.stream().map(m -> m.getOption() + " overwrites " + (String)((Match)m).mandatoryOption.getKey() + (String)((Match)m).mandatoryOption.getValue()).collect(Collectors.joining(", "))));
        }
    }

    public T add(String str) {
        Objects.requireNonNull(str, JVM_OPTION_NOT_NULL_ERROR_MESSAGE);
        String value = str.trim();
        if (JvmOptions.isInvalidOption(value)) {
            throw new IllegalArgumentException("a JVM option can't be empty and must start with '-'");
        }
        this.checkMandatoryOptionOverwrite(value);
        this.options.add(value);
        return this.castThis();
    }

    private void checkMandatoryOptionOverwrite(String value) {
        Map.Entry<String, String> overriddenMandatoryOption = this.mandatoryOptionFor(value);
        if (overriddenMandatoryOption != null) {
            throw new MessageException(String.format("a JVM option can't overwrite mandatory JVM options. %s overwrites %s", value, overriddenMandatoryOption.getKey() + overriddenMandatoryOption.getValue()));
        }
    }

    @CheckForNull
    private Map.Entry<String, String> mandatoryOptionFor(String jvmOption) {
        return this.mandatoryOptions.entrySet().stream().filter(s -> jvmOption.startsWith((String)s.getKey()) && !jvmOption.equals((String)s.getKey() + (String)s.getValue())).findFirst().orElse(null);
    }

    private static boolean isInvalidOption(String value) {
        return value.isEmpty() || !value.startsWith("-");
    }

    private T castThis() {
        return (T)this;
    }

    public List<String> getAll() {
        return new ArrayList<String>(this.options);
    }

    public String toString() {
        return this.options.toString();
    }

    private static final class Match {
        private final String option;
        private final Map.Entry<String, String> mandatoryOption;

        private Match(String option, @Nullable Map.Entry<String, String> mandatoryOption) {
            this.option = option;
            this.mandatoryOption = mandatoryOption;
        }

        String getOption() {
            return this.option;
        }

        @CheckForNull
        Map.Entry<String, String> getMandatoryOption() {
            return this.mandatoryOption;
        }
    }
}

