/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;
import org.sonar.application.config.AppSettings;
import org.sonar.application.config.AppSettingsImpl;
import org.sonar.application.config.AppSettingsLoader;
import org.sonar.application.config.ClusterSettings;
import org.sonar.application.config.CommandLineParser;
import org.sonar.application.config.FileSystemSettings;
import org.sonar.application.config.JdbcSettings;
import org.sonar.process.ConfigurationUtils;
import org.sonar.process.NetworkUtilsImpl;
import org.sonar.process.ProcessProperties;
import org.sonar.process.Props;

public class AppSettingsLoaderImpl
implements AppSettingsLoader {
    private final File homeDir;
    private final String[] cliArguments;
    private final Consumer<Props>[] consumers;

    public AppSettingsLoaderImpl(String[] cliArguments) {
        this(cliArguments, AppSettingsLoaderImpl.detectHomeDir(), new FileSystemSettings(), new JdbcSettings(), new ClusterSettings(NetworkUtilsImpl.INSTANCE));
    }

    AppSettingsLoaderImpl(String[] cliArguments, File homeDir, Consumer<Props> ... consumers) {
        this.cliArguments = cliArguments;
        this.homeDir = homeDir;
        this.consumers = consumers;
    }

    File getHomeDir() {
        return this.homeDir;
    }

    @Override
    public AppSettings load() {
        Properties p = AppSettingsLoaderImpl.loadPropertiesFile(this.homeDir);
        p.putAll((Map<?, ?>)CommandLineParser.parseArguments(this.cliArguments));
        p.setProperty(ProcessProperties.Property.PATH_HOME.getKey(), this.homeDir.getAbsolutePath());
        p = ConfigurationUtils.interpolateVariables((Properties)p, System.getenv());
        Props props = new Props(p);
        ProcessProperties.completeDefaults((Props)props);
        Arrays.stream(this.consumers).forEach(c -> c.accept(props));
        return new AppSettingsImpl(props);
    }

    private static File detectHomeDir() {
        try {
            File appJar = new File(Class.forName("org.sonar.application.App").getProtectionDomain().getCodeSource().getLocation().toURI());
            return appJar.getParentFile().getParentFile();
        }
        catch (ClassNotFoundException | URISyntaxException e) {
            throw new IllegalStateException("Cannot detect path of main jar file", e);
        }
    }

    private static Properties loadPropertiesFile(File homeDir) {
        Properties p;
        block15: {
            p = new Properties();
            File propsFile = new File(homeDir, "conf/sonar.properties");
            if (propsFile.exists()) {
                try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(propsFile), StandardCharsets.UTF_8);){
                    p.load(reader);
                    break block15;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot open file " + propsFile, e);
                }
            }
            LoggerFactory.getLogger(AppSettingsLoaderImpl.class).warn("Configuration file not found: {}", (Object)propsFile);
        }
        return p;
    }
}

