/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.config;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class CommandLineParser {
    private CommandLineParser() {
    }

    public static Properties parseArguments(String[] args) {
        Properties props = CommandLineParser.argumentsToProperties(args);
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("sonar.")) continue;
            props.setProperty(key, entry.getValue().toString());
        }
        return props;
    }

    static Properties argumentsToProperties(String[] args) {
        Properties props = new Properties();
        for (String arg : args) {
            if (!arg.startsWith("-D") || !arg.contains("=")) {
                throw new IllegalArgumentException(String.format("Command-line argument must start with -D, for example -Dsonar.jdbc.username=sonar. Got: %s", arg));
            }
            String key = StringUtils.substringBefore((String)arg, (String)"=").substring(2);
            String value = StringUtils.substringAfter((String)arg, (String)"=");
            props.setProperty(key, value);
        }
        return props;
    }
}

