/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class SonarQubeVersionHelper {
    private static final String SONARQUBE_VERSION_PATH = "/sonarqube-version.txt";
    private static String sonarqubeVersion;

    private SonarQubeVersionHelper() {
    }

    public static String getSonarqubeVersion() {
        if (sonarqubeVersion == null) {
            SonarQubeVersionHelper.loadVersion();
        }
        return sonarqubeVersion;
    }

    private static synchronized void loadVersion() {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(SonarQubeVersionHelper.class.getResourceAsStream(SONARQUBE_VERSION_PATH), StandardCharsets.UTF_8));){
            sonarqubeVersion = in.readLine();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Cannot load %s from classpath", SONARQUBE_VERSION_PATH), e);
        }
    }
}

