/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.es;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.sonar.application.command.EsJvmOptions;
import org.sonar.application.es.EsInstallation;
import org.sonar.application.es.EsYmlSettings;
import org.sonar.process.ProcessProperties;
import org.sonar.process.Props;

public class EsInstallationImpl
implements EsInstallation {
    private final File homeDirectory;
    private final List<File> outdatedSearchDirectories;
    private final File dataDirectory;
    private final File confDirectory;
    private final File logDirectory;
    private final File tmpDirectory;
    private EsJvmOptions esJvmOptions;
    private EsYmlSettings esYmlSettings;
    private Properties log4j2Properties;
    private String clusterName;
    private String host;
    private int port;

    public EsInstallationImpl(Props props) {
        File sqHomeDir = props.nonNullValueAsFile(ProcessProperties.Property.PATH_HOME.getKey());
        this.homeDirectory = new File(sqHomeDir, "elasticsearch");
        this.outdatedSearchDirectories = EsInstallationImpl.buildOutdatedSearchDirs(props);
        this.dataDirectory = EsInstallationImpl.buildDataDir(props);
        this.confDirectory = EsInstallationImpl.buildConfDir(props);
        this.logDirectory = EsInstallationImpl.buildLogDir(props);
        this.tmpDirectory = EsInstallationImpl.buildTmpDir(props);
    }

    private static List<File> buildOutdatedSearchDirs(Props props) {
        String dataPath = props.nonNullValue(ProcessProperties.Property.PATH_DATA.getKey());
        return Arrays.asList(new File(dataPath, "es"), new File(dataPath, "es5"));
    }

    private static File buildDataDir(Props props) {
        String dataPath = props.nonNullValue(ProcessProperties.Property.PATH_DATA.getKey());
        return new File(dataPath, "es6");
    }

    private static File buildConfDir(Props props) {
        File tmpDir = props.nonNullValueAsFile(ProcessProperties.Property.PATH_TEMP.getKey());
        return new File(new File(tmpDir, "conf"), "es");
    }

    private static File buildLogDir(Props props) {
        return props.nonNullValueAsFile(ProcessProperties.Property.PATH_LOGS.getKey());
    }

    private static File buildTmpDir(Props props) {
        File tmpDir = props.nonNullValueAsFile(ProcessProperties.Property.PATH_TEMP.getKey());
        return new File(tmpDir, "es6");
    }

    @Override
    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    @Override
    public List<File> getOutdatedSearchDirectories() {
        return Collections.unmodifiableList(this.outdatedSearchDirectories);
    }

    @Override
    public File getDataDirectory() {
        return this.dataDirectory;
    }

    @Override
    public File getConfDirectory() {
        return this.confDirectory;
    }

    @Override
    public File getLogDirectory() {
        return this.logDirectory;
    }

    @Override
    public File getTmpDirectory() {
        return this.tmpDirectory;
    }

    @Override
    public File getExecutable() {
        return new File(this.homeDirectory, "bin/elasticsearch");
    }

    @Override
    public File getLog4j2PropertiesLocation() {
        return new File(this.confDirectory, "log4j2.properties");
    }

    @Override
    public File getElasticsearchYml() {
        return new File(this.confDirectory, "elasticsearch.yml");
    }

    @Override
    public File getJvmOptions() {
        return new File(this.confDirectory, "jvm.options");
    }

    @Override
    public File getLibDirectory() {
        return new File(this.homeDirectory, "lib");
    }

    @Override
    public EsJvmOptions getEsJvmOptions() {
        return this.esJvmOptions;
    }

    public EsInstallationImpl setEsJvmOptions(EsJvmOptions esJvmOptions) {
        this.esJvmOptions = esJvmOptions;
        return this;
    }

    @Override
    public EsYmlSettings getEsYmlSettings() {
        return this.esYmlSettings;
    }

    public EsInstallationImpl setEsYmlSettings(EsYmlSettings esYmlSettings) {
        this.esYmlSettings = esYmlSettings;
        return this;
    }

    @Override
    public Properties getLog4j2Properties() {
        return this.log4j2Properties;
    }

    public EsInstallationImpl setLog4j2Properties(Properties log4j2Properties) {
        this.log4j2Properties = log4j2Properties;
        return this;
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    public EsInstallationImpl setClusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public EsInstallationImpl setHost(String host) {
        this.host = host;
        return this;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public EsInstallationImpl setPort(int port) {
        this.port = port;
        return this;
    }
}

