/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.es;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class EsYmlSettings {
    private static final String ELASTICSEARCH_YML_OPTIONS_HEADER = "# This file has been automatically generated by SonarQube during startup.\n\n# DO NOT EDIT THIS FILE\n\n";
    private final Map<String, String> elasticsearchSettings;

    public EsYmlSettings(Map<String, String> elasticsearchSettings) {
        this.elasticsearchSettings = elasticsearchSettings;
    }

    public void writeToYmlSettingsFile(File file) {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setPrettyFlow(true);
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(dumperOptions);
        String output = ELASTICSEARCH_YML_OPTIONS_HEADER + yaml.dump(this.elasticsearchSettings);
        try {
            Files.write(file.toPath(), output.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot write Elasticsearch yml settings file", e);
        }
    }
}

