/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.process;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.application.process.ProcessMonitor;
import org.sonar.process.ProcessId;

abstract class AbstractProcessMonitor
implements ProcessMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProcessMonitor.class);
    private static final int EXPECTED_EXIT_VALUE = 0;
    protected final Process process;
    private final ProcessId processId;

    protected AbstractProcessMonitor(Process process, ProcessId processId) {
        this.process = process;
        this.processId = processId;
    }

    @Override
    public InputStream getInputStream() {
        return this.process.getInputStream();
    }

    @Override
    public InputStream getErrorStream() {
        return this.process.getErrorStream();
    }

    @Override
    public void closeStreams() {
        AbstractProcessMonitor.closeQuietly(this.process.getInputStream());
        AbstractProcessMonitor.closeQuietly(this.process.getOutputStream());
        AbstractProcessMonitor.closeQuietly(this.process.getErrorStream());
    }

    private static void closeQuietly(@Nullable Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isAlive() {
        return this.process.isAlive();
    }

    @Override
    public void destroyForcibly() {
        this.process.destroyForcibly();
    }

    @Override
    public void waitFor() throws InterruptedException {
        int exitValue = this.process.waitFor();
        if (exitValue != 0) {
            LOG.warn("Process exited with exit value [{}]: {}", (Object)this.processId.getKey(), (Object)exitValue);
        } else {
            LOG.debug("Process exited with exit value [{}]: {}", (Object)this.processId.getKey(), (Object)exitValue);
        }
    }

    @Override
    public void waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        this.process.waitFor(timeout, unit);
    }
}

