/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.application.process.Lifecycle;
import org.sonar.application.process.ProcessEventListener;
import org.sonar.application.process.ProcessLifecycleListener;
import org.sonar.application.process.ProcessMonitor;
import org.sonar.application.process.StreamGobbler;
import org.sonar.process.ProcessId;

public class SQProcess {
    public static final long DEFAULT_WATCHER_DELAY_MS = 500L;
    private static final Logger LOG = LoggerFactory.getLogger(SQProcess.class);
    private final ProcessId processId;
    private final Lifecycle lifecycle;
    private final List<ProcessEventListener> eventListeners;
    private final long watcherDelayMs;
    private ProcessMonitor process;
    private StreamGobbler stdOutGobbler;
    private StreamGobbler stdErrGobbler;
    private final StopWatcher stopWatcher;
    private final EventWatcher eventWatcher;
    private final AtomicBoolean operational = new AtomicBoolean(false);

    private SQProcess(Builder builder) {
        this.processId = Objects.requireNonNull(builder.processId, "processId can't be null");
        this.lifecycle = new Lifecycle(this.processId, builder.lifecycleListeners);
        this.eventListeners = builder.eventListeners;
        this.watcherDelayMs = builder.watcherDelayMs;
        this.stopWatcher = new StopWatcher();
        this.eventWatcher = new EventWatcher();
    }

    public boolean start(Supplier<ProcessMonitor> commandLauncher) {
        if (!this.lifecycle.tryToMoveTo(Lifecycle.State.STARTING)) {
            return false;
        }
        try {
            this.process = commandLauncher.get();
        }
        catch (RuntimeException e) {
            LOG.error("Fail to launch process [{}]", (Object)this.processId.getKey(), (Object)e);
            this.lifecycle.tryToMoveTo(Lifecycle.State.STOPPED);
            throw e;
        }
        this.stdOutGobbler = new StreamGobbler(this.process.getInputStream(), this.processId.getKey());
        this.stdOutGobbler.start();
        this.stdErrGobbler = new StreamGobbler(this.process.getErrorStream(), this.processId.getKey());
        this.stdErrGobbler.start();
        this.stopWatcher.start();
        this.eventWatcher.start();
        this.lifecycle.tryToMoveTo(Lifecycle.State.STARTED);
        return true;
    }

    public ProcessId getProcessId() {
        return this.processId;
    }

    Lifecycle.State getState() {
        return this.lifecycle.getState();
    }

    public void stop(long timeout, TimeUnit timeoutUnit) {
        if (this.lifecycle.tryToMoveTo(Lifecycle.State.STOPPING)) {
            this.stopGracefully(timeout, timeoutUnit);
            if (this.process != null && this.process.isAlive()) {
                LOG.info("{} failed to stop in a timely fashion. Killing it.", (Object)this.processId.getKey());
            }
            this.stopForcibly();
        } else {
            this.waitForDown();
        }
    }

    private void waitForDown() {
        while (this.process != null && this.process.isAlive()) {
            try {
                this.process.waitFor();
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void stopGracefully(long timeout, TimeUnit timeoutUnit) {
        if (this.process == null) {
            return;
        }
        try {
            this.process.askForStop();
            this.process.waitFor(timeout, timeoutUnit);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while stopping process {}", (Object)this.processId, (Object)e);
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            LOG.error("Can not ask for graceful stop of process {}", (Object)this.processId, (Object)e);
        }
    }

    public void stopForcibly() {
        this.eventWatcher.interrupt();
        this.stopWatcher.interrupt();
        if (this.process != null) {
            this.process.destroyForcibly();
            this.waitForDown();
            this.process.closeStreams();
        }
        if (this.stdOutGobbler != null) {
            StreamGobbler.waitUntilFinish(this.stdOutGobbler);
            this.stdOutGobbler.interrupt();
        }
        if (this.stdErrGobbler != null) {
            StreamGobbler.waitUntilFinish(this.stdErrGobbler);
            this.stdErrGobbler.interrupt();
        }
        this.lifecycle.tryToMoveTo(Lifecycle.State.STOPPED);
    }

    void refreshState() {
        if (this.process.isAlive()) {
            if (!this.operational.get() && this.process.isOperational()) {
                this.operational.set(true);
                this.eventListeners.forEach(l -> l.onProcessEvent(this.processId, ProcessEventListener.Type.OPERATIONAL));
            }
            if (this.process.askedForRestart()) {
                this.process.acknowledgeAskForRestart();
                this.eventListeners.forEach(l -> l.onProcessEvent(this.processId, ProcessEventListener.Type.ASK_FOR_RESTART));
            }
        } else {
            this.stopForcibly();
        }
    }

    public String toString() {
        return String.format("Process[%s]", this.processId.getKey());
    }

    public static Builder builder(ProcessId processId) {
        return new Builder(processId);
    }

    public static class Builder {
        private final ProcessId processId;
        private final List<ProcessEventListener> eventListeners = new ArrayList<ProcessEventListener>();
        private final List<ProcessLifecycleListener> lifecycleListeners = new ArrayList<ProcessLifecycleListener>();
        private long watcherDelayMs = 500L;

        private Builder(ProcessId processId) {
            this.processId = processId;
        }

        public Builder addEventListener(ProcessEventListener listener) {
            this.eventListeners.add(listener);
            return this;
        }

        public Builder addProcessLifecycleListener(ProcessLifecycleListener listener) {
            this.lifecycleListeners.add(listener);
            return this;
        }

        public Builder setWatcherDelayMs(long l) {
            this.watcherDelayMs = l;
            return this;
        }

        public SQProcess build() {
            return new SQProcess(this);
        }
    }

    private class EventWatcher
    extends Thread {
        EventWatcher() {
            super(String.format("EventWatcher[%s]", SQProcess.this.processId.getKey()));
        }

        @Override
        public void run() {
            try {
                while (SQProcess.this.process.isAlive()) {
                    SQProcess.this.refreshState();
                    Thread.sleep(SQProcess.this.watcherDelayMs);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                SQProcess.this.stopForcibly();
            }
        }
    }

    private class StopWatcher
    extends Thread {
        StopWatcher() {
            super(String.format("StopWatcher[%s]", SQProcess.this.processId.getKey()));
        }

        @Override
        public void run() {
            try {
                SQProcess.this.process.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            SQProcess.this.stopForcibly();
        }
    }
}

