/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugin.typescript.executable;

import java.io.File;
import java.io.InputStream;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugin.typescript.executable.ExecutableBundleFactory;
import org.sonar.plugin.typescript.executable.SonarTSCoreBundle;
import org.sonar.plugin.typescript.executable.Zip;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide(lifespan="MULTIPLE_ANALYSES")
public class SonarTSCoreBundleFactory
implements ExecutableBundleFactory {
    private static final Logger LOG = Loggers.get(SonarTSCoreBundleFactory.class);
    private String bundleLocation;

    public SonarTSCoreBundleFactory(String bundleLocation) {
        this.bundleLocation = bundleLocation;
    }

    @Override
    public SonarTSCoreBundle createAndDeploy(File deployDestination, Configuration configuration) {
        InputStream bundle = this.getClass().getResourceAsStream(this.bundleLocation);
        if (bundle == null) {
            throw new IllegalStateException("SonarTS bundle not found at " + this.bundleLocation);
        }
        try {
            LOG.debug("Deploying bundle to {}", (Object)deployDestination.getAbsolutePath());
            Zip.extract(bundle, deployDestination);
            return new SonarTSCoreBundle(new File(deployDestination, "sonarts-bundle"), configuration);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to deploy SonarTS bundle (with classpath '" + this.bundleLocation + "')", e);
        }
    }
}

