/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce;

import com.hazelcast.spi.exception.RetryableHazelcastException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.picocontainer.Startable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.CeDistributedInformation;
import org.sonar.ce.taskprocessor.CeWorker;
import org.sonar.ce.taskprocessor.CeWorkerFactory;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.process.cluster.hz.HazelcastMember;

public class CeDistributedInformationImpl
implements CeDistributedInformation,
Startable {
    private static final Logger LOGGER = Loggers.get(CeDistributedInformationImpl.class);
    private final HazelcastMember hazelcastMember;
    private final CeWorkerFactory ceCeWorkerFactory;

    public CeDistributedInformationImpl(HazelcastMember hazelcastMember, CeWorkerFactory ceCeWorkerFactory) {
        this.hazelcastMember = hazelcastMember;
        this.ceCeWorkerFactory = ceCeWorkerFactory;
    }

    @Override
    public Set<String> getWorkerUUIDs() {
        Set connectedWorkerUUIDs = this.hazelcastMember.getMemberUuids();
        return (Set)this.getClusteredWorkerUUIDs().entrySet().stream().filter(e -> connectedWorkerUUIDs.contains(e.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).collect(MoreCollectors.toSet());
    }

    @Override
    public void broadcastWorkerUUIDs() {
        Set<CeWorker> workers = this.ceCeWorkerFactory.getWorkers();
        Set workerUuids = (Set)workers.stream().map(CeWorker::getUUID).collect(MoreCollectors.toSet((int)workers.size()));
        this.getClusteredWorkerUUIDs().put(this.hazelcastMember.getUuid(), workerUuids);
    }

    @Override
    public Lock acquireCleanJobLock() {
        return this.hazelcastMember.getLock("CE_CLEANING_JOB_LOCK");
    }

    public void start() {
    }

    public void stop() {
        try {
            this.getClusteredWorkerUUIDs().remove(this.hazelcastMember.getUuid());
        }
        catch (RetryableHazelcastException e) {
            LOGGER.debug("Unable to remove worker UUID from the list of active workers", (Object)e.getMessage());
        }
    }

    private Map<String, Set<String>> getClusteredWorkerUUIDs() {
        return this.hazelcastMember.getReplicatedMap("WORKER_UUIDS");
    }
}

