/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce;

import com.google.common.base.Preconditions;
import org.sonar.ce.ComputeEngine;
import org.sonar.ce.container.ComputeEngineContainer;
import org.sonar.ce.container.ComputeEngineStatus;
import org.sonar.process.Props;

public class ComputeEngineImpl
implements ComputeEngine,
ComputeEngineStatus {
    private final Props props;
    private final ComputeEngineContainer computeEngineContainer;
    private ComputeEngineStatus.Status status = ComputeEngineStatus.Status.INIT;

    public ComputeEngineImpl(Props props, ComputeEngineContainer computeEngineContainer) {
        this.props = props;
        this.computeEngineContainer = computeEngineContainer;
        computeEngineContainer.setComputeEngineStatus(this);
    }

    @Override
    public void startup() {
        Preconditions.checkState((this.status == ComputeEngineStatus.Status.INIT ? 1 : 0) != 0, (Object)"startup() can not be called multiple times");
        try {
            this.status = ComputeEngineStatus.Status.STARTING;
            this.computeEngineContainer.start(this.props);
        }
        finally {
            this.status = ComputeEngineStatus.Status.STARTED;
        }
    }

    @Override
    public void shutdown() {
        ComputeEngineImpl.checkStateAsShutdown(this.status);
        try {
            this.status = ComputeEngineStatus.Status.STOPPING;
            this.computeEngineContainer.stop();
        }
        finally {
            this.status = ComputeEngineStatus.Status.STOPPED;
        }
    }

    private static void checkStateAsShutdown(ComputeEngineStatus.Status currentStatus) {
        Preconditions.checkState((currentStatus.ordinal() >= ComputeEngineStatus.Status.STARTED.ordinal() ? 1 : 0) != 0, (Object)"shutdown() must not be called before startup()");
        Preconditions.checkState((currentStatus.ordinal() <= ComputeEngineStatus.Status.STOPPING.ordinal() ? 1 : 0) != 0, (Object)"shutdown() can not be called multiple times");
    }

    @Override
    public ComputeEngineStatus.Status getStatus() {
        return this.status;
    }
}

