/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.app;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.ComputeEngine;
import org.sonar.ce.ComputeEngineImpl;
import org.sonar.ce.container.ComputeEngineContainerImpl;
import org.sonar.ce.logging.CeProcessLogging;
import org.sonar.process.MessageException;
import org.sonar.process.MinimumViableSystem;
import org.sonar.process.Monitored;
import org.sonar.process.ProcessEntryPoint;
import org.sonar.process.ProcessUtils;
import org.sonar.process.Props;

public class CeServer
implements Monitored {
    private static final Logger LOG = Loggers.get(CeServer.class);
    private static final String CE_MAIN_THREAD_NAME = "ce-main";
    private AtomicReference<Thread> awaitThread = new AtomicReference();
    private volatile boolean stopAwait = false;
    private final ComputeEngine computeEngine;
    @Nullable
    private CeMainThread ceMainThread = null;

    @VisibleForTesting
    protected CeServer(ComputeEngine computeEngine, MinimumViableSystem mvs) {
        this.computeEngine = computeEngine;
        mvs.checkWritableTempDir().checkRequiredJavaOptions((Map)ImmutableMap.of((Object)"file.encoding", (Object)"UTF-8"));
    }

    public void start() {
        Preconditions.checkState((this.ceMainThread == null ? 1 : 0) != 0, (Object)"start() can not be called twice");
        this.ceMainThread = new CeMainThread();
        this.ceMainThread.start();
    }

    public Monitored.Status getStatus() {
        Preconditions.checkState((this.ceMainThread != null ? 1 : 0) != 0, (Object)"getStatus() can not be called before start()");
        if (this.ceMainThread.isStarted()) {
            return this.ceMainThread.isOperational() ? Monitored.Status.OPERATIONAL : Monitored.Status.FAILED;
        }
        return Monitored.Status.DOWN;
    }

    public void awaitStop() {
        Preconditions.checkState((boolean)this.awaitThread.compareAndSet(null, Thread.currentThread()), (Object)"There can't be more than one thread waiting for the Compute Engine to stop");
        Preconditions.checkState((this.ceMainThread != null ? 1 : 0) != 0, (Object)"awaitStop() must not be called before start()");
        try {
            while (!this.stopAwait) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.awaitThread = null;
        }
    }

    public void stop() {
        if (this.ceMainThread != null) {
            this.ceMainThread.stopIt();
            ProcessUtils.awaitTermination((Thread)this.ceMainThread);
        }
    }

    public static void main(String[] args) {
        ProcessEntryPoint entryPoint = ProcessEntryPoint.createForArguments((String[])args);
        Props props = entryPoint.getProps();
        new CeProcessLogging().configure(props);
        CeServer server = new CeServer(new ComputeEngineImpl(props, new ComputeEngineContainerImpl()), new MinimumViableSystem());
        entryPoint.launch((Monitored)server);
    }

    private class CeMainThread
    extends Thread {
        private static final int CHECK_FOR_STOP_DELAY = 50;
        private volatile boolean stop;
        private volatile boolean started;
        private volatile boolean operational;

        public CeMainThread() {
            super(CeServer.CE_MAIN_THREAD_NAME);
            this.stop = false;
            this.started = false;
            this.operational = false;
        }

        @Override
        public void run() {
            boolean startupSuccessful;
            this.operational = startupSuccessful = this.attemptStartup();
            this.started = true;
            if (startupSuccessful) {
                this.waitForStopSignal();
            } else {
                this.stopAwait();
            }
        }

        private boolean attemptStartup() {
            try {
                this.startup();
                return true;
            }
            catch (org.sonar.api.utils.MessageException | MessageException e) {
                LOG.error("Compute Engine startup failed: " + e.getMessage());
                return false;
            }
            catch (Throwable e) {
                LOG.error("Compute Engine startup failed", e);
                return false;
            }
        }

        private void startup() {
            LOG.info("Compute Engine starting up...");
            CeServer.this.computeEngine.startup();
            LOG.info("Compute Engine is operational");
        }

        private void waitForStopSignal() {
            while (!this.stop) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.attemptShutdown();
        }

        private void attemptShutdown() {
            try {
                LOG.info("Compute Engine is stopping...");
                CeServer.this.computeEngine.shutdown();
                LOG.info("Compute Engine is stopped");
            }
            catch (Throwable e) {
                LOG.error("Compute Engine failed to stop", e);
            }
            finally {
                this.stopAwait();
            }
        }

        public boolean isStarted() {
            return this.started;
        }

        public boolean isOperational() {
            return this.operational;
        }

        public void stopIt() {
            this.stop = true;
            this.interrupt();
        }

        private void stopAwait() {
            CeServer.this.stopAwait = true;
            Thread t = (Thread)CeServer.this.awaitThread.get();
            if (t != null) {
                t.interrupt();
                try {
                    t.join(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

