/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.httpd;

import com.google.common.base.Preconditions;
import fi.iki.elonen.NanoHTTPD;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.LoggerFactory;
import org.sonar.ce.httpd.HttpAction;
import org.sonar.process.sharedmemoryfile.DefaultProcessCommands;

public class CeHttpServer {
    private final Properties processProps;
    private final List<HttpAction> actions;
    private final ActionRegistryImpl actionRegistry;
    private final CeNanoHttpd nanoHttpd;

    public CeHttpServer(Properties processProps, List<HttpAction> actions) {
        this.processProps = processProps;
        this.actions = actions;
        this.actionRegistry = new ActionRegistryImpl();
        this.nanoHttpd = new CeNanoHttpd(InetAddress.getLoopbackAddress().getHostAddress(), 0, this.actionRegistry);
    }

    public void start() {
        try {
            this.registerActions();
            this.nanoHttpd.start();
            this.registerHttpUrl();
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not start local HTTP server for System Info monitoring", e);
        }
    }

    private void registerActions() {
        this.actions.forEach(action -> action.register(this.actionRegistry));
    }

    private void registerHttpUrl() {
        int processNumber = Integer.parseInt(this.processProps.getProperty("process.index"));
        File shareDir = new File(this.processProps.getProperty("process.sharedDir"));
        try (DefaultProcessCommands commands = DefaultProcessCommands.secondary((File)shareDir, (int)processNumber);){
            String url = this.getUrl();
            commands.setHttpUrl(url);
            LoggerFactory.getLogger(this.getClass()).debug("System Info HTTP server listening at {}", (Object)url);
        }
    }

    public void stop() {
        this.nanoHttpd.stop();
    }

    String getUrl() {
        return "http://" + this.nanoHttpd.getHostname() + ":" + this.nanoHttpd.getListeningPort();
    }

    private static final class ActionRegistryImpl
    implements HttpAction.ActionRegistry {
        private final Map<String, HttpAction> actionsByPath = new HashMap<String, HttpAction>();

        private ActionRegistryImpl() {
        }

        @Override
        public void register(String path, HttpAction action) {
            Objects.requireNonNull(path, "path can't be null");
            Objects.requireNonNull(action, "action can't be null");
            Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0, (Object)"path can't be empty");
            Preconditions.checkArgument((!path.startsWith("/") ? 1 : 0) != 0, (Object)"path must not start with '/'");
            String fixedPath = path.toLowerCase(Locale.ENGLISH);
            HttpAction existingAction = this.actionsByPath.put(fixedPath, action);
            Preconditions.checkState((existingAction == null ? 1 : 0) != 0, (String)"Action '%s' already registered for path '%s'", (Object[])new Object[]{existingAction, fixedPath});
        }

        Optional<HttpAction> getAction(NanoHTTPD.IHTTPSession session) {
            String path = session.getUri().substring(1).toLowerCase(Locale.ENGLISH);
            return Optional.ofNullable(this.actionsByPath.get(path));
        }
    }

    private static class CeNanoHttpd
    extends NanoHTTPD {
        private final ActionRegistryImpl actionRegistry;

        CeNanoHttpd(String hostname, int port, ActionRegistryImpl actionRegistry) {
            super(hostname, port);
            this.actionRegistry = actionRegistry;
        }

        public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
            return this.actionRegistry.getAction(session).map(action -> CeNanoHttpd.serveFromAction(session, action)).orElseGet(() -> CeNanoHttpd.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)String.format("Error 404, '%s' not found.", session.getUri())));
        }

        private static NanoHTTPD.Response serveFromAction(NanoHTTPD.IHTTPSession session, HttpAction action) {
            try {
                return action.serve(session);
            }
            catch (Exception e) {
                return CeNanoHttpd.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)e.getMessage());
            }
        }
    }
}

