/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.logging;

import fi.iki.elonen.NanoHTTPD;
import org.sonar.api.utils.log.LoggerLevel;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.httpd.HttpAction;
import org.sonar.server.log.ServerLogging;

public class ChangeLogLevelHttpAction
implements HttpAction {
    private static final String PATH = "changeLogLevel";
    private static final String PARAM_LEVEL = "level";
    private final ServerLogging logging;

    public ChangeLogLevelHttpAction(ServerLogging logging) {
        this.logging = logging;
    }

    @Override
    public void register(HttpAction.ActionRegistry registry) {
        registry.register(PATH, this);
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        if (session.getMethod() != NanoHTTPD.Method.POST) {
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.METHOD_NOT_ALLOWED, (String)"text/plain", null);
        }
        String levelStr = (String)session.getParms().get(PARAM_LEVEL);
        if (levelStr == null || levelStr.isEmpty()) {
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)String.format("Parameter '%s' is missing", PARAM_LEVEL));
        }
        try {
            LoggerLevel level = LoggerLevel.valueOf((String)levelStr);
            this.logging.changeLevel(level);
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", null);
        }
        catch (IllegalArgumentException e) {
            Loggers.get(ChangeLogLevelHttpAction.class).debug("Value '{}' for parameter 'level' is invalid: {}", (Object)levelStr, (Object)e);
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)String.format("Value '%s' for parameter '%s' is invalid", levelStr, PARAM_LEVEL));
        }
    }
}

