/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.monitoring;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.picocontainer.Startable;
import org.sonar.ce.configuration.CeConfiguration;
import org.sonar.ce.monitoring.CEQueueStatus;
import org.sonar.ce.monitoring.CeTasksMBean;
import org.sonar.ce.taskprocessor.CeWorker;
import org.sonar.ce.taskprocessor.CeWorkerController;
import org.sonar.ce.taskprocessor.CeWorkerFactory;
import org.sonar.process.Jmx;
import org.sonar.process.systeminfo.SystemInfoSection;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;

public class CeTasksMBeanImpl
implements CeTasksMBean,
Startable,
SystemInfoSection {
    private final CEQueueStatus queueStatus;
    private final CeConfiguration ceConfiguration;
    private final CeWorkerFactory ceWorkerFactory;
    private final CeWorkerController ceWorkerController;

    public CeTasksMBeanImpl(CEQueueStatus queueStatus, CeConfiguration ceConfiguration, CeWorkerFactory ceWorkerFactory, CeWorkerController CeWorkerController2) {
        this.queueStatus = queueStatus;
        this.ceConfiguration = ceConfiguration;
        this.ceWorkerFactory = ceWorkerFactory;
        this.ceWorkerController = CeWorkerController2;
    }

    public void start() {
        Jmx.register((String)"SonarQube:name=ComputeEngineTasks", (Object)this);
    }

    public void stop() {
        Jmx.unregister((String)"SonarQube:name=ComputeEngineTasks");
    }

    @Override
    public long getPendingCount() {
        return this.queueStatus.getPendingCount();
    }

    @Override
    public long getInProgressCount() {
        return this.queueStatus.getInProgressCount();
    }

    @Override
    public long getErrorCount() {
        return this.queueStatus.getErrorCount();
    }

    @Override
    public long getSuccessCount() {
        return this.queueStatus.getSuccessCount();
    }

    @Override
    public long getProcessingTime() {
        return this.queueStatus.getProcessingTime();
    }

    @Override
    public int getWorkerMaxCount() {
        return this.ceConfiguration.getWorkerMaxCount();
    }

    @Override
    public int getWorkerCount() {
        return this.ceConfiguration.getWorkerCount();
    }

    @Override
    public List<String> getWorkerUuids() {
        Set<CeWorker> workers = this.ceWorkerFactory.getWorkers();
        return workers.stream().map(CeWorker::getUUID).sorted().collect(Collectors.toList());
    }

    @Override
    public List<String> getEnabledWorkerUuids() {
        Set<CeWorker> workers = this.ceWorkerFactory.getWorkers();
        return workers.stream().filter(this.ceWorkerController::isEnabled).map(CeWorker::getUUID).sorted().collect(Collectors.toList());
    }

    public ProtobufSystemInfo.Section toProtobuf() {
        ProtobufSystemInfo.Section.Builder builder = ProtobufSystemInfo.Section.newBuilder();
        builder.setName("Compute Engine Tasks");
        builder.addAttributesBuilder().setKey("Pending").setLongValue(this.getPendingCount()).build();
        builder.addAttributesBuilder().setKey("In Progress").setLongValue(this.getInProgressCount()).build();
        builder.addAttributesBuilder().setKey("Processed With Error").setLongValue(this.getErrorCount()).build();
        builder.addAttributesBuilder().setKey("Processed With Success").setLongValue(this.getSuccessCount()).build();
        builder.addAttributesBuilder().setKey("Processing Time (ms)").setLongValue(this.getProcessingTime()).build();
        builder.addAttributesBuilder().setKey("Worker Count").setLongValue((long)this.getWorkerCount()).build();
        builder.addAttributesBuilder().setKey("Max Worker Count").setLongValue((long)this.getWorkerMaxCount()).build();
        builder.addAttributesBuilder().setKey("Workers Paused").setBooleanValue(this.queueStatus.areWorkersPaused()).build();
        return builder.build();
    }
}

