/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.queue;

import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.api.Startable;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeActivityDto;

@ComputeEngineSide
public class PurgeCeActivities
implements Startable {
    private static final Logger LOGGER = Loggers.get(PurgeCeActivities.class);
    private final DbClient dbClient;
    private final System2 system2;

    public PurgeCeActivities(DbClient dbClient, System2 system2) {
        this.dbClient = dbClient;
        this.system2 = system2;
    }

    public void start() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Date sixMonthsAgo = DateUtils.addDays((Date)new Date(this.system2.now()), (int)-180);
            LOGGER.info("Delete the Compute Engine tasks created before {}", (Object)sixMonthsAgo.getTime());
            Set ceActivityUuids = (Set)this.dbClient.ceActivityDao().selectOlderThan(dbSession, sixMonthsAgo.getTime()).stream().map(CeActivityDto::getUuid).collect(MoreCollectors.toSet());
            this.dbClient.ceActivityDao().deleteByUuids(dbSession, ceActivityUuids);
            this.dbClient.ceTaskCharacteristicsDao().deleteByTaskUuids(dbSession, ceActivityUuids);
            this.dbClient.ceTaskInputDao().deleteByUuids(dbSession, (Collection)ceActivityUuids);
            Date fourWeeksAgo = DateUtils.addDays((Date)new Date(this.system2.now()), (int)-28);
            LOGGER.info("Delete the Scanner contexts tasks created before {}", (Object)fourWeeksAgo.getTime());
            Set scannerContextUuids = this.dbClient.ceScannerContextDao().selectOlderThan(dbSession, fourWeeksAgo.getTime());
            this.dbClient.ceScannerContextDao().deleteByUuids(dbSession, (Collection)Stream.concat(ceActivityUuids.stream(), scannerContextUuids.stream()).collect(MoreCollectors.toSet()));
            dbSession.commit();
        }
    }

    public void stop() {
    }
}

