/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.systeminfo;

import fi.iki.elonen.NanoHTTPD;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.sonar.ce.httpd.HttpAction;
import org.sonar.process.systeminfo.SystemInfoSection;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;

public class SystemInfoHttpAction
implements HttpAction {
    private static final String PATH = "systemInfo";
    private static final String PROTOBUF_MIME_TYPE = "application/x-protobuf";
    private final List<SystemInfoSection> sectionProviders;

    public SystemInfoHttpAction(List<SystemInfoSection> sectionProviders) {
        this.sectionProviders = sectionProviders;
    }

    @Override
    public void register(HttpAction.ActionRegistry registry) {
        registry.register(PATH, this);
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        if (session.getMethod() != NanoHTTPD.Method.GET) {
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.METHOD_NOT_ALLOWED, (String)"text/plain", null);
        }
        ProtobufSystemInfo.SystemInfo.Builder infoBuilder = ProtobufSystemInfo.SystemInfo.newBuilder();
        for (SystemInfoSection sectionProvider : this.sectionProviders) {
            ProtobufSystemInfo.Section section = sectionProvider.toProtobuf();
            infoBuilder.addSections(section);
        }
        byte[] bytes = infoBuilder.build().toByteArray();
        return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)PROTOBUF_MIME_TYPE, (InputStream)new ByteArrayInputStream(bytes), (long)bytes.length);
    }
}

