/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.taskprocessor;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.ce.queue.InternalCeQueue;
import org.sonar.ce.taskprocessor.CeTaskProcessorRepository;
import org.sonar.ce.taskprocessor.CeWorker;
import org.sonar.ce.taskprocessor.CeWorkerController;
import org.sonar.ce.taskprocessor.CeWorkerFactory;
import org.sonar.ce.taskprocessor.CeWorkerImpl;
import org.sonar.core.util.UuidFactory;
import org.sonar.core.util.stream.MoreCollectors;

public class CeWorkerFactoryImpl
implements CeWorkerFactory {
    private final UuidFactory uuidFactory;
    private final InternalCeQueue queue;
    private final CeTaskProcessorRepository taskProcessorRepository;
    private final CeWorkerController ceWorkerController;
    private final CeWorker.ExecutionListener[] executionListeners;
    private Set<CeWorker> ceWorkers = Collections.emptySet();

    public CeWorkerFactoryImpl(InternalCeQueue queue, CeTaskProcessorRepository taskProcessorRepository, UuidFactory uuidFactory, CeWorkerController ceWorkerController) {
        this(queue, taskProcessorRepository, uuidFactory, ceWorkerController, new CeWorker.ExecutionListener[0]);
    }

    public CeWorkerFactoryImpl(InternalCeQueue queue, CeTaskProcessorRepository taskProcessorRepository, UuidFactory uuidFactory, CeWorkerController ceWorkerController, CeWorker.ExecutionListener[] executionListeners) {
        this.queue = queue;
        this.taskProcessorRepository = taskProcessorRepository;
        this.uuidFactory = uuidFactory;
        this.ceWorkerController = ceWorkerController;
        this.executionListeners = executionListeners;
    }

    @Override
    public CeWorker create(int ordinal) {
        String uuid = this.uuidFactory.create();
        CeWorkerImpl ceWorker = new CeWorkerImpl(ordinal, uuid, this.queue, this.taskProcessorRepository, this.ceWorkerController, this.executionListeners);
        this.ceWorkers = (Set)Stream.concat(this.ceWorkers.stream(), Stream.of(ceWorker)).collect(MoreCollectors.toSet((int)(this.ceWorkers.size() + 1)));
        return ceWorker;
    }

    @Override
    public Set<CeWorker> getWorkers() {
        return this.ceWorkers;
    }
}

