/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.taskprocessor;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.CeTask;
import org.sonar.ce.task.CeTaskInterruptedException;
import org.sonar.ce.task.CeTaskTimeoutException;
import org.sonar.ce.taskprocessor.CeWorker;
import org.sonar.ce.taskprocessor.CeWorkerController;
import org.sonar.ce.taskprocessor.SimpleCeTaskInterrupter;

public class TimeoutCeTaskInterrupter
extends SimpleCeTaskInterrupter {
    private final long taskTimeoutThreshold;
    private final CeWorkerController ceWorkerController;
    private final System2 system2;
    private final Map<String, Long> startTimestampByCeTaskUuid = new HashMap<String, Long>();

    public TimeoutCeTaskInterrupter(long taskTimeoutThreshold, CeWorkerController ceWorkerController, System2 system2) {
        Preconditions.checkArgument((taskTimeoutThreshold >= 1L ? 1 : 0) != 0, (Object)"threshold must be >= 1");
        Loggers.get(TimeoutCeTaskInterrupter.class).info("Compute Engine Task timeout enabled: {} ms", (Object)taskTimeoutThreshold);
        this.taskTimeoutThreshold = taskTimeoutThreshold;
        this.ceWorkerController = ceWorkerController;
        this.system2 = system2;
    }

    @Override
    public void check(Thread currentThread) throws CeTaskInterruptedException {
        super.check(currentThread);
        this.computeTimeOutOf(this.taskOf(currentThread)).ifPresent(timeout -> {
            throw new CeTaskTimeoutException(String.format("Execution of task timed out after %s ms", timeout));
        });
    }

    private Optional<Long> computeTimeOutOf(CeTask ceTask) {
        Long startTimestamp = this.startTimestampByCeTaskUuid.get(ceTask.getUuid());
        Preconditions.checkState((startTimestamp != null ? 1 : 0) != 0, (String)"No start time recorded for task %s", (Object[])new Object[]{ceTask.getUuid()});
        long duration = this.system2.now() - startTimestamp;
        return Optional.of(duration).filter(t -> t > this.taskTimeoutThreshold);
    }

    private CeTask taskOf(Thread currentThread) {
        return (CeTask)this.ceWorkerController.getCeWorkerIn(currentThread).flatMap(CeWorker::getCurrentTask).orElseThrow(() -> new IllegalStateException(String.format("Could not find the CeTask being executed in thread '%s'", currentThread.getName())));
    }

    @Override
    public void onStart(CeTask ceTask) {
        long now = this.system2.now();
        Long existingTimestamp = this.startTimestampByCeTaskUuid.put(ceTask.getUuid(), now);
        if (existingTimestamp != null) {
            Loggers.get(TimeoutCeTaskInterrupter.class).warn("Notified of start of execution of task %s but start had already been recorded at %s. Recording new start at %s", new Object[]{ceTask.getUuid(), existingTimestamp, now});
        }
    }

    @Override
    public void onEnd(CeTask ceTask) {
        Long startTimestamp = this.startTimestampByCeTaskUuid.remove(ceTask.getUuid());
        if (startTimestamp == null) {
            Loggers.get(TimeoutCeTaskInterrupter.class).warn("Notified of end of execution of task %s but start wasn't recorded", (Object)ceTask.getUuid());
        }
    }
}

