/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.pylint;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.ExtensionPoint;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.config.Settings;

@ScannerSide
@ExtensionPoint
public class PylintConfiguration {
    public static final String PYLINT_CONFIG_KEY = "sonar.python.pylint_config";
    public static final String PYLINT_KEY = "sonar.python.pylint";
    private final Settings conf;

    public PylintConfiguration(Settings conf) {
        this.conf = conf;
    }

    public String getPylintConfigPath(FileSystem fileSystem) {
        String configPath = this.conf.getString(PYLINT_CONFIG_KEY);
        if (StringUtils.isEmpty(configPath)) {
            return null;
        }
        File configFile = new File(configPath);
        if (!configFile.isAbsolute()) {
            File projectRoot = fileSystem.baseDir();
            configFile = new File(projectRoot.getPath(), configPath);
        }
        return configFile.getAbsolutePath();
    }

    public String getPylintPath() {
        return this.conf.getString(PYLINT_KEY);
    }
}

