/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.pylint;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.pylint.Issue;

public class PylintReportParser {
    private static final Pattern PATTERN = Pattern.compile("(.+):([0-9]+): \\[(.*)\\] (.*)");
    private static final Logger LOG = Loggers.get(PylintReportParser.class);
    private static final Map<String, String> ID_MAP = PylintReportParser.initializeIdMap();

    private static Map<String, String> initializeIdMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("E9900", "E1300");
        map.put("E9901", "E1301");
        map.put("E9902", "E1302");
        map.put("E9903", "E1303");
        map.put("E9904", "E1304");
        map.put("E9905", "E1305");
        map.put("E9906", "E1306");
        map.put("W6501", "W1201");
        map.put("W9900", "W1300");
        map.put("W9901", "W1301");
        return Collections.unmodifiableMap(map);
    }

    public Issue parseLine(String line) {
        Issue issue = null;
        if (line.length() > 0) {
            if (!PylintReportParser.isDetail(line)) {
                Matcher m = PATTERN.matcher(line);
                if (m.matches() && m.groupCount() == 4) {
                    String filename = m.group(1);
                    int linenr = Integer.valueOf(m.group(2));
                    String[] parts = m.group(3).split(",");
                    String ruleid = PylintReportParser.ruleId(parts[0].trim());
                    String objname = parts.length == 2 ? parts[1].trim() : "";
                    String descr = m.group(4);
                    issue = new Issue(filename, linenr, ruleid, objname, descr);
                } else {
                    LOG.debug("Cannot parse the line: {}", (Object)line);
                }
            } else {
                LOG.trace("Classifying as detail and ignoring line '{}'", (Object)line);
            }
        }
        return issue;
    }

    private static String ruleId(String ruleAndMessageIds) {
        String ruleid = ruleAndMessageIds;
        int parenthesisIndex = ruleid.indexOf(40);
        if (parenthesisIndex > -1) {
            ruleid = ruleid.substring(0, parenthesisIndex);
        }
        if (ID_MAP.containsKey(ruleid)) {
            ruleid = ID_MAP.get(ruleid);
        }
        return ruleid;
    }

    private static boolean isDetail(String line) {
        char first = line.charAt(0);
        return first == ' ' || first == '\t' || first == '\n';
    }
}

