/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.sslr.ast.AstSelect;

@Rule(key="S1066")
public class CollapsibleIfStatementsCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1066";
    private static final String MESSAGE = "Merge this if statement with the enclosing one.";

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return Collections.singleton(PythonGrammar.IF_STMT);
    }

    @Override
    public void visitNode(AstNode node) {
        AstNode suite = node.getLastChild(PythonGrammar.SUITE);
        if (suite.getPreviousSibling().getPreviousSibling().is(PythonKeyword.ELSE)) {
            return;
        }
        AstNode singleIfChild = CollapsibleIfStatementsCheck.singleIfChild(suite);
        if (singleIfChild != null && !CollapsibleIfStatementsCheck.hasElseOrElif(singleIfChild)) {
            this.addIssue(singleIfChild.getToken(), MESSAGE).secondary(node.getFirstChild(), "enclosing");
        }
    }

    private static boolean hasElseOrElif(AstNode ifNode) {
        return ifNode.hasDirectChildren(PythonKeyword.ELIF) || ifNode.hasDirectChildren(PythonKeyword.ELSE);
    }

    private static AstNode singleIfChild(AstNode suite) {
        AstSelect nestedIf;
        List<AstNode> statements = suite.getChildren(PythonGrammar.STATEMENT);
        if (statements.size() == 1 && (nestedIf = statements.get(0).select().children((AstNodeType)PythonGrammar.COMPOUND_STMT).children((AstNodeType)PythonGrammar.IF_STMT)).size() == 1) {
            return nestedIf.get(0);
        }
        return null;
    }
}

