/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonTokenType;
import org.sonar.sslr.ast.AstSelect;

@Rule(key="S2772")
public class NeedlessPassCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S2772";
    private static final String MESSAGE = "Remove this unneeded \"pass\".";

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return Collections.singleton(PythonGrammar.PASS_STMT);
    }

    @Override
    public void visitNode(AstNode node) {
        AstNode suite = node.getFirstAncestor((AstNodeType)PythonGrammar.SUITE);
        if (suite != null) {
            List<AstNode> statements = suite.getChildren(PythonGrammar.STATEMENT);
            if (statements.size() > 1) {
                if (!NeedlessPassCheck.docstringException(statements)) {
                    this.addIssue(node, MESSAGE);
                }
            } else {
                this.visitOneOrZeroStatement(node, suite, statements.size());
            }
        }
    }

    private static boolean docstringException(List<AstNode> statements) {
        return statements.size() == 2 && statements.get(0).getToken().getType().equals(PythonTokenType.STRING);
    }

    private void visitOneOrZeroStatement(AstNode node, AstNode suite, int statementNumber) {
        AstSelect simpleStatements = statementNumber == 1 ? suite.select().children((AstNodeType)PythonGrammar.STATEMENT).children((AstNodeType)PythonGrammar.STMT_LIST).children((AstNodeType)PythonGrammar.SIMPLE_STMT) : suite.select().children((AstNodeType)PythonGrammar.STMT_LIST).children((AstNodeType)PythonGrammar.SIMPLE_STMT);
        if (simpleStatements.size() > 1) {
            this.addIssue(node, MESSAGE);
        }
    }
}

