/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;

@Rule(key="S1523")
public class DynamicCodeExecutionCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S1523";
    private static final String MESSAGE = "Make sure that this dynamic injection or execution of code is safe.";

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return DynamicCodeExecutionCheck.immutableSet(PythonGrammar.CALL_EXPR);
    }

    @Override
    public void visitNode(AstNode callExpression) {
        String functionName;
        AstNode functionNameNode = callExpression.getFirstChild(PythonGrammar.ATOM);
        if (functionNameNode != null && ((functionName = functionNameNode.getTokenValue()).equals("exec") || functionName.equals("eval"))) {
            this.addIssue(callExpression, MESSAGE);
        }
    }
}

