/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.semantic.Symbol;

@Rule(key="S4784")
public class RegexCheck
extends PythonCheck {
    public static final String CHECK_KEY = "S4784";
    private static final String MESSAGE = "Make sure that using a regular expression is safe here.";
    private static final Set<String> questionableFunctions = RegexCheck.immutableSet("django.core.validators.RegexValidator", "django.urls.re_path", "re.compile", "re.match", "re.search", "re.fullmatch", "re.split", "re.findall", "re.finditer", "re.sub", "re.subn", "regex.compile", "regex.match", "regex.search", "regex.fullmatch", "regex.split", "regex.findall", "regex.finditer", "regex.sub", "regex.subn", "regex.subf", "regex.subfn", "regex.splititer");

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return RegexCheck.immutableSet(PythonGrammar.ATTRIBUTE_REF, PythonGrammar.ATOM);
    }

    @Override
    public void visitNode(AstNode node) {
        Symbol symbol = this.getContext().symbolTable().getSymbol(node);
        if (symbol != null && questionableFunctions.contains(symbol.qualifiedName())) {
            AstNode parent = node.getParent();
            if (parent != null && parent.is(PythonGrammar.CALL_EXPR)) {
                this.addIssue(parent, MESSAGE);
            } else {
                this.addIssue(node, MESSAGE);
            }
        }
    }
}

