/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.matchers;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.sonar.sslr.internal.matchers.TextLocation;

public class LocatedText
implements CharSequence {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private final File file;
    private final URI uri;
    private final char[] chars;
    private final int[] lines;

    public LocatedText(@Nullable File file, char[] chars) {
        this.file = file;
        this.uri = file == null ? null : file.toURI();
        this.chars = chars;
        this.lines = LocatedText.computeLines(chars);
    }

    @Override
    public int length() {
        return this.chars.length;
    }

    public char[] toChars() {
        char[] chars = new char[this.length()];
        System.arraycopy(this.chars, 0, chars, 0, chars.length);
        return chars;
    }

    @Override
    public char charAt(int index) {
        return this.chars[index];
    }

    @Override
    public CharSequence subSequence(int from, int to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return new String(this.toChars());
    }

    TextLocation getLocation(int index) {
        if (index < 0 || index > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        int line = this.getLineNumber(index);
        int column = index - this.getLineStart(line) + 1;
        return new TextLocation(this.file, this.uri, line, column);
    }

    private int getLineNumber(int index) {
        int i = Arrays.binarySearch(this.lines, index);
        return i >= 0 ? i + 2 : -i;
    }

    private int getLineStart(int line) {
        return line == 1 ? 0 : this.lines[line - 2];
    }

    private static int[] computeLines(char[] chars) {
        int i;
        ArrayList<Integer> newlines = new ArrayList<Integer>();
        for (i = 0; i < chars.length; ++i) {
            if (!LocatedText.isEndOfLine(chars, i)) continue;
            newlines.add(i + 1);
        }
        if (newlines.isEmpty()) {
            return EMPTY_INT_ARRAY;
        }
        int[] lines = new int[newlines.size()];
        for (i = 0; i < newlines.size(); ++i) {
            lines[i] = (Integer)newlines.get(i);
        }
        return lines;
    }

    private static boolean isEndOfLine(char[] buffer, int i) {
        return buffer[i] == '\n' || buffer[i] == '\r' && (i + 1 < buffer.length && buffer[i + 1] != '\n' || i + 1 == buffer.length);
    }
}

