/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.index;

import org.sonar.api.config.Configuration;
import org.sonar.api.config.internal.MapSettings;
import org.sonar.server.es.Index;
import org.sonar.server.es.IndexDefinition;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.newindex.DefaultIndexSettingsElement;
import org.sonar.server.es.newindex.KeywordFieldBuilder;
import org.sonar.server.es.newindex.NewAuthorizedIndex;
import org.sonar.server.es.newindex.SettingsConfiguration;
import org.sonar.server.es.newindex.StringFieldBuilder;
import org.sonar.server.es.newindex.TypeMapping;

public class ComponentIndexDefinition
implements IndexDefinition {
    public static final Index DESCRIPTOR = Index.withRelations("components");
    public static final IndexType.IndexRelationType TYPE_COMPONENT = IndexType.relation(IndexType.main(DESCRIPTOR, "auth"), "component");
    public static final String FIELD_UUID = "uuid";
    public static final String FIELD_PROJECT_UUID = "project_uuid";
    public static final String FIELD_ORGANIZATION_UUID = "organization_uuid";
    public static final String FIELD_KEY = "key";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_QUALIFIER = "qualifier";
    public static final String FIELD_LANGUAGE = "language";
    private static final int DEFAULT_NUMBER_OF_SHARDS = 5;
    static final DefaultIndexSettingsElement[] NAME_ANALYZERS = new DefaultIndexSettingsElement[]{DefaultIndexSettingsElement.SORTABLE_ANALYZER, DefaultIndexSettingsElement.SEARCH_PREFIX_ANALYZER, DefaultIndexSettingsElement.SEARCH_PREFIX_CASE_INSENSITIVE_ANALYZER, DefaultIndexSettingsElement.SEARCH_GRAMS_ANALYZER};
    private final Configuration config;
    private final boolean enableSource;

    private ComponentIndexDefinition(Configuration config, boolean enableSource) {
        this.config = config;
        this.enableSource = enableSource;
    }

    public ComponentIndexDefinition(Configuration config) {
        this(config, false);
    }

    public static ComponentIndexDefinition createForTest() {
        return new ComponentIndexDefinition(new MapSettings().asConfig(), true);
    }

    @Override
    public void define(IndexDefinition.IndexDefinitionContext context) {
        NewAuthorizedIndex index = (NewAuthorizedIndex)context.createWithAuthorization(DESCRIPTOR, SettingsConfiguration.newBuilder(this.config).setRefreshInterval(-1).setDefaultNbOfShards(5).build()).setEnableSource(this.enableSource);
        TypeMapping mapping = index.createTypeMapping(TYPE_COMPONENT);
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_UUID).disableNorms()).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_PROJECT_UUID).disableNorms()).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_KEY).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        ((StringFieldBuilder)((StringFieldBuilder)((StringFieldBuilder)mapping.textFieldBuilder(FIELD_NAME).withFieldData().store()).termVectorWithPositionOffsets()).addSubFields(NAME_ANALYZERS)).build();
        mapping.keywordFieldBuilder(FIELD_QUALIFIER).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_LANGUAGE).disableNorms()).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ORGANIZATION_UUID).disableNorms()).build();
    }
}

