/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.elasticsearch.action.index.IndexRequest;
import org.sonar.server.es.EsUtils;
import org.sonar.server.es.IndexType;

public abstract class BaseDoc {
    private static final String SETPARENT_NOT_CALLED = "parent must be set on a doc associated to a IndexRelationType (see BaseDoc#setParent(String))";
    private final IndexType indexType;
    private String parentId = null;
    protected final Map<String, Object> fields;

    protected BaseDoc(IndexType indexType) {
        this(indexType, new HashMap<String, Object>());
    }

    protected BaseDoc(IndexType indexType, Map<String, Object> fields) {
        IndexType.IndexMainType mainType;
        this.indexType = indexType;
        this.fields = fields;
        if (indexType instanceof IndexType.IndexMainType && (mainType = (IndexType.IndexMainType)indexType).getIndex().acceptsRelations()) {
            this.setField(mainType.getIndex().getJoinField(), ImmutableMap.of((Object)"name", (Object)mainType.getType()));
            this.setField("indexType", mainType.getType());
        }
    }

    protected void setParent(String parentId) {
        Preconditions.checkState((boolean)(this.indexType instanceof IndexType.IndexRelationType), (Object)"Doc must be associated to a IndexRelationType to set a parent");
        Preconditions.checkArgument((parentId != null && !parentId.isEmpty() ? 1 : 0) != 0, (Object)"parentId can't be null nor empty");
        this.parentId = parentId;
        IndexType.IndexRelationType indexRelationType = (IndexType.IndexRelationType)this.indexType;
        this.setField(indexRelationType.getMainType().getIndex().getJoinField(), ImmutableMap.of((Object)"name", (Object)indexRelationType.getName(), (Object)"parent", (Object)parentId));
        this.setField("indexType", indexRelationType.getName());
    }

    public abstract String getId();

    public Optional<String> getRouting() {
        if (this.indexType instanceof IndexType.IndexRelationType) {
            this.ensureSetParentCalled();
            return Optional.of(this.parentId);
        }
        if (this.indexType instanceof IndexType.IndexMainType && this.indexType.getMainType().getIndex().acceptsRelations()) {
            return Optional.of(this.getId());
        }
        return this.getSimpleMainTypeRouting();
    }

    protected Optional<String> getSimpleMainTypeRouting() {
        return Optional.empty();
    }

    @CheckForNull
    public <K> K getNullableField(String key) {
        if (!this.fields.containsKey(key)) {
            throw new IllegalStateException(String.format("Field %s not specified in query options", key));
        }
        return (K)this.fields.get(key);
    }

    @CheckForNull
    public Date getNullableFieldAsDate(String key) {
        Object val = this.getNullableField(key);
        if (val != null) {
            if (val instanceof Date) {
                return (Date)val;
            }
            if (val instanceof Number) {
                return BaseDoc.epochSecondsToDate((Number)val);
            }
            return EsUtils.parseDateTime((String)val);
        }
        return null;
    }

    public <K> K getField(String key) {
        K value = this.getNullableField(key);
        if (value == null) {
            throw new IllegalStateException("Value of index field is null: " + key);
        }
        return value;
    }

    public Date getFieldAsDate(String key) {
        Object value = this.getField(key);
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            return BaseDoc.epochSecondsToDate((Number)value);
        }
        return EsUtils.parseDateTime((String)value);
    }

    public void setField(String key, @Nullable Object value) {
        this.fields.put(key, value);
    }

    public final Map<String, Object> getFields() {
        if (this.indexType instanceof IndexType.IndexRelationType) {
            this.ensureSetParentCalled();
        }
        return this.fields;
    }

    private void ensureSetParentCalled() {
        Preconditions.checkState((this.parentId != null ? 1 : 0) != 0, (Object)SETPARENT_NOT_CALLED);
    }

    public IndexRequest toIndexRequest() {
        IndexType.IndexMainType mainType = this.indexType.getMainType();
        return new IndexRequest(mainType.getIndex().getName(), mainType.getType()).id(this.getId()).routing((String)this.getRouting().orElse(null)).source(this.getFields());
    }

    public static long epochMillisToEpochSeconds(long epochMillis) {
        return epochMillis / 1000L;
    }

    private static Date epochSecondsToDate(Number value) {
        return new Date(value.longValue() * 1000L);
    }

    public static long dateToEpochSeconds(Date date) {
        return BaseDoc.epochMillisToEpochSeconds(date.getTime());
    }
}

