/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import java.io.Closeable;
import java.util.Objects;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsRequestBuilder;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequestBuilder;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequestBuilder;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchScrollRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.Priority;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.es.Index;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.request.ProxyClearCacheRequestBuilder;
import org.sonar.server.es.request.ProxyClusterHealthRequestBuilder;
import org.sonar.server.es.request.ProxyClusterStateRequestBuilder;
import org.sonar.server.es.request.ProxyClusterStatsRequestBuilder;
import org.sonar.server.es.request.ProxyCreateIndexRequestBuilder;
import org.sonar.server.es.request.ProxyDeleteRequestBuilder;
import org.sonar.server.es.request.ProxyGetRequestBuilder;
import org.sonar.server.es.request.ProxyIndexRequestBuilder;
import org.sonar.server.es.request.ProxyIndicesExistsRequestBuilder;
import org.sonar.server.es.request.ProxyIndicesStatsRequestBuilder;
import org.sonar.server.es.request.ProxyNodesStatsRequestBuilder;
import org.sonar.server.es.request.ProxyPutMappingRequestBuilder;
import org.sonar.server.es.request.ProxyRefreshRequestBuilder;
import org.sonar.server.es.request.ProxySearchRequestBuilder;
import org.sonar.server.es.request.ProxySearchScrollRequestBuilder;

public class EsClient
implements Closeable {
    public static final Logger LOGGER = Loggers.get((String)"es");
    private final Client nativeClient;

    public EsClient(Client nativeClient) {
        this.nativeClient = Objects.requireNonNull(nativeClient);
    }

    public EsClient() {
        this.nativeClient = null;
    }

    public RefreshRequestBuilder prepareRefresh(Index index) {
        return (RefreshRequestBuilder)new ProxyRefreshRequestBuilder(this.nativeClient()).setIndices(new String[]{index.getName()});
    }

    public IndicesStatsRequestBuilder prepareStats() {
        return new ProxyIndicesStatsRequestBuilder(this.nativeClient());
    }

    public IndicesStatsRequestBuilder prepareStats(Index index) {
        return (IndicesStatsRequestBuilder)new ProxyIndicesStatsRequestBuilder(this.nativeClient()).setIndices(new String[]{index.getName()});
    }

    public NodesStatsRequestBuilder prepareNodesStats(String ... nodesIds) {
        return (NodesStatsRequestBuilder)new ProxyNodesStatsRequestBuilder(this.nativeClient()).setNodesIds(nodesIds);
    }

    public ClusterStatsRequestBuilder prepareClusterStats() {
        return new ProxyClusterStatsRequestBuilder(this.nativeClient());
    }

    public ClusterStateRequestBuilder prepareState() {
        return new ProxyClusterStateRequestBuilder(this.nativeClient());
    }

    public ClusterHealthRequestBuilder prepareHealth() {
        return new ProxyClusterHealthRequestBuilder(this.nativeClient());
    }

    public void waitForStatus(ClusterHealthStatus status) {
        this.prepareHealth().setWaitForEvents(Priority.LANGUID).setWaitForStatus(status).get();
    }

    public IndicesExistsRequestBuilder prepareIndicesExist(Index index) {
        return new ProxyIndicesExistsRequestBuilder(this.nativeClient(), index.getName());
    }

    public CreateIndexRequestBuilder prepareCreate(Index index) {
        return new ProxyCreateIndexRequestBuilder(this.nativeClient(), index.getName());
    }

    public PutMappingRequestBuilder preparePutMapping(Index index) {
        return new ProxyPutMappingRequestBuilder(this.nativeClient()).setIndices(new String[]{index.getName()});
    }

    public SearchRequestBuilder prepareSearch(Index index) {
        return new ProxySearchRequestBuilder(this.nativeClient()).setIndices(new String[]{index.getName()});
    }

    public SearchRequestBuilder prepareSearch(IndexType.IndexMainType indexType) {
        return new ProxySearchRequestBuilder(this.nativeClient()).setIndices(new String[]{indexType.getIndex().getName()}).setTypes(new String[]{indexType.getType()});
    }

    public SearchScrollRequestBuilder prepareSearchScroll(String scrollId) {
        return new ProxySearchScrollRequestBuilder(scrollId, this.nativeClient());
    }

    public GetRequestBuilder prepareGet(IndexType indexType, String id) {
        IndexType.IndexMainType mainType = indexType.getMainType();
        return ((GetRequestBuilder)new ProxyGetRequestBuilder(this.nativeClient()).setIndex(mainType.getIndex().getName())).setType(mainType.getType()).setId(id);
    }

    public DeleteRequestBuilder prepareDelete(IndexType indexType, String id) {
        IndexType.IndexMainType mainType = indexType.getMainType();
        return new ProxyDeleteRequestBuilder(this.nativeClient(), mainType.getIndex().getName()).setType(mainType.getType()).setId(id);
    }

    DeleteRequestBuilder prepareDelete(String index, String type, String id) {
        return new ProxyDeleteRequestBuilder(this.nativeClient(), index).setType(type).setId(id);
    }

    public IndexRequestBuilder prepareIndex(IndexType indexType) {
        IndexType.IndexMainType mainType = indexType.getMainType();
        return ((IndexRequestBuilder)new ProxyIndexRequestBuilder(this.nativeClient()).setIndex(mainType.getIndex().getName())).setType(mainType.getType());
    }

    public ForceMergeRequestBuilder prepareForceMerge(String indexName) {
        return this.nativeClient().admin().indices().prepareForceMerge(new String[]{indexName}).setMaxNumSegments(1);
    }

    public ClearIndicesCacheRequestBuilder prepareClearCache(String ... indices) {
        return (ClearIndicesCacheRequestBuilder)new ProxyClearCacheRequestBuilder(this.nativeClient()).setIndices(indices);
    }

    public Client nativeClient() {
        return this.nativeClient;
    }

    @Override
    public void close() {
        this.nativeClient.close();
    }
}

