/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.metadata;

import java.util.Optional;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.common.document.DocumentField;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.Index;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.metadata.MetadataIndexDefinition;
import org.sonar.server.es.newindex.DefaultIndexSettings;

public class MetadataIndex {
    private static final String DB_VENDOR_KEY = "dbVendor";
    private final EsClient esClient;

    public MetadataIndex(EsClient esClient) {
        this.esClient = esClient;
    }

    public Optional<String> getHash(Index index) {
        return this.getMetadata(MetadataIndex.hashId(index));
    }

    public void setHash(Index index, String hash) {
        this.setMetadata(MetadataIndex.hashId(index), hash);
    }

    private static String hashId(Index index) {
        return index.getName() + ".indexStructure";
    }

    public boolean getInitialized(IndexType indexType) {
        return this.getMetadata(MetadataIndex.initializedId(indexType)).map(Boolean::parseBoolean).orElse(false);
    }

    public void setInitialized(IndexType indexType, boolean initialized) {
        this.setMetadata(MetadataIndex.initializedId(indexType), String.valueOf(initialized));
    }

    private static String initializedId(IndexType indexType) {
        if (indexType instanceof IndexType.IndexMainType) {
            IndexType.IndexMainType mainType = (IndexType.IndexMainType)indexType;
            return mainType.getIndex().getName() + "." + mainType.getType() + ".initialized";
        }
        if (indexType instanceof IndexType.IndexRelationType) {
            IndexType.IndexRelationType relationType = (IndexType.IndexRelationType)indexType;
            IndexType.IndexMainType mainType = relationType.getMainType();
            return mainType.getIndex().getName() + "." + mainType.getType() + "." + relationType.getName() + ".initialized";
        }
        throw new IllegalArgumentException("Unsupported IndexType " + indexType.getClass());
    }

    public Optional<String> getDbVendor() {
        return this.getMetadata(DB_VENDOR_KEY);
    }

    public void setDbMetadata(String vendor) {
        this.setMetadata(DB_VENDOR_KEY, vendor);
    }

    private Optional<String> getMetadata(String id) {
        GetRequestBuilder request = this.esClient.prepareGet(MetadataIndexDefinition.TYPE_METADATA, id).setStoredFields(new String[]{"value"});
        GetResponse response = (GetResponse)request.get();
        if (response.isExists()) {
            DocumentField field = response.getField("value");
            return Optional.of(field.getValue());
        }
        return Optional.empty();
    }

    private void setMetadata(String id, String value) {
        ((IndexRequestBuilder)this.esClient.prepareIndex(MetadataIndexDefinition.TYPE_METADATA).setId(id).setSource(new Object[]{"value", value}).setRefreshPolicy(DefaultIndexSettings.REFRESH_IMMEDIATE)).get();
    }
}

