/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.newindex;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sonar.api.config.Configuration;

public class SettingsConfiguration {
    public static final int MANUAL_REFRESH_INTERVAL = -1;
    private final Configuration configuration;
    private final int defaultNbOfShards;
    private final int refreshInterval;

    private SettingsConfiguration(Builder builder) {
        this.configuration = builder.configuration;
        this.defaultNbOfShards = builder.defaultNbOfShards;
        this.refreshInterval = builder.refreshInterval;
    }

    public static Builder newBuilder(Configuration configuration) {
        return new Builder(configuration);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public int getDefaultNbOfShards() {
        return this.defaultNbOfShards;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public static class Builder {
        private final Configuration configuration;
        private int defaultNbOfShards = 1;
        private int refreshInterval = 30;

        public Builder(Configuration configuration) {
            this.configuration = Objects.requireNonNull(configuration, "configuration can't be null");
        }

        public Builder setDefaultNbOfShards(int defaultNbOfShards) {
            Preconditions.checkArgument((defaultNbOfShards >= 1 ? 1 : 0) != 0, (Object)"defaultNbOfShards must be >= 1");
            this.defaultNbOfShards = defaultNbOfShards;
            return this;
        }

        public Builder setRefreshInterval(int refreshInterval) {
            Preconditions.checkArgument((refreshInterval == -1 || refreshInterval > 0 ? 1 : 0) != 0, (Object)"refreshInterval must be either -1 or strictly positive");
            this.refreshInterval = refreshInterval;
            return this;
        }

        public SettingsConfiguration build() {
            return new SettingsConfiguration(this);
        }
    }
}

