/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.newindex;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.sonar.server.es.newindex.DefaultIndexSettingsElement;
import org.sonar.server.es.newindex.FieldAware;

public abstract class StringFieldBuilder<U extends FieldAware<U>, T extends StringFieldBuilder<U, T>> {
    private final U parent;
    private final String fieldName;
    private boolean disableSearch = false;
    private boolean disableNorms = false;
    private boolean termVectorWithPositionOffsets = false;
    private SortedMap<String, Object> subFields = Maps.newTreeMap();
    private boolean store = false;
    protected boolean disabledDocValues = false;

    protected StringFieldBuilder(U parent, String fieldName) {
        this.parent = parent;
        this.fieldName = fieldName;
    }

    private T addSubField(String fieldName, SortedMap<String, String> fieldDefinition) {
        this.subFields.put(fieldName, fieldDefinition);
        return this.castThis();
    }

    public T addSubFields(DefaultIndexSettingsElement ... analyzers) {
        Arrays.stream(analyzers).forEach(analyzer -> this.addSubField(analyzer.getSubFieldSuffix(), analyzer.fieldMapping()));
        return this.castThis();
    }

    public T disableNorms() {
        this.disableNorms = true;
        return this.castThis();
    }

    public T termVectorWithPositionOffsets() {
        this.termVectorWithPositionOffsets = true;
        return this.castThis();
    }

    public T disableSearch() {
        this.disableSearch = true;
        return this.castThis();
    }

    public T store() {
        this.store = true;
        return this.castThis();
    }

    private T castThis() {
        return (T)this;
    }

    public U build() {
        if (this.subFields.isEmpty()) {
            return this.buildWithoutSubfields();
        }
        return this.buildWithSubfields();
    }

    private U buildWithoutSubfields() {
        TreeMap<String, String> hash = new TreeMap<String, String>();
        hash.put("type", this.getFieldType());
        hash.put("index", this.disableSearch ? "false" : "true");
        hash.put("norms", String.valueOf(!this.disableNorms));
        hash.put("store", String.valueOf(this.store));
        if ("keyword".equals(this.getFieldType())) {
            hash.put("doc_values", String.valueOf(!this.disabledDocValues));
        }
        if (this.getFieldData()) {
            hash.put("fielddata", "true");
        }
        return ((FieldAware)this.parent).setField(this.fieldName, hash);
    }

    private U buildWithSubfields() {
        TreeMap<String, Object> hash = new TreeMap<String, Object>();
        hash.put("type", this.getFieldType());
        hash.put("index", this.disableSearch ? "false" : "true");
        hash.put("norms", "false");
        hash.put("store", String.valueOf(this.store));
        if ("keyword".equals(this.getFieldType())) {
            hash.put("doc_values", String.valueOf(!this.disabledDocValues));
        }
        if (this.getFieldData()) {
            hash.put("fielddata", "true");
        }
        if (this.termVectorWithPositionOffsets) {
            hash.put("term_vector", "with_positions_offsets");
        }
        hash.put("fields", this.configureSubFields());
        return ((FieldAware)this.parent).setField(this.fieldName, hash);
    }

    private Map<String, Object> configureSubFields() {
        TreeMap<String, Object> multiFields = new TreeMap<String, Object>(this.subFields);
        multiFields.entrySet().forEach(entry -> {
            Object subFieldMapping = entry.getValue();
            if (subFieldMapping instanceof Map) {
                entry.setValue(this.configureSubField((Map)subFieldMapping));
            }
        });
        return multiFields;
    }

    private Map<String, String> configureSubField(Map<String, String> subFieldMapping) {
        TreeMap<String, String> subHash = new TreeMap<String, String>(subFieldMapping);
        subHash.put("index", "true");
        subHash.put("norms", "false");
        subHash.put("store", String.valueOf(this.store));
        if (this.termVectorWithPositionOffsets) {
            subHash.put("term_vector", "with_positions_offsets");
        }
        return subHash;
    }

    protected abstract boolean getFieldData();

    protected abstract String getFieldType();
}

