/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.request;

import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingAction;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.es.EsClient;

public class ProxyPutMappingRequestBuilder
extends PutMappingRequestBuilder {
    public ProxyPutMappingRequestBuilder(Client client) {
        super((ElasticsearchClient)client.admin().indices(), PutMappingAction.INSTANCE);
    }

    public AcknowledgedResponse get() {
        Profiler profiler = Profiler.createIfTrace((Logger)EsClient.LOGGER).start();
        try {
            AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)super.execute().actionGet();
            return acknowledgedResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to execute %s", this.toString()), e);
        }
        finally {
            if (profiler.isTraceEnabled()) {
                profiler.stopTrace(this.toString());
            }
        }
    }

    public AcknowledgedResponse get(TimeValue timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public AcknowledgedResponse get(String timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ActionFuture<AcknowledgedResponse> execute() {
        throw new UnsupportedOperationException("execute() should not be called as it's used for asynchronous");
    }

    public String toString() {
        String source;
        String type;
        StringBuilder message = new StringBuilder();
        message.append("ES put mapping request");
        if (((PutMappingRequest)this.request).indices().length > 0) {
            message.append(String.format(" on indices '%s'", StringUtils.join((Object[])((PutMappingRequest)this.request).indices(), (String)",")));
        }
        if ((type = ((PutMappingRequest)this.request).type()) != null) {
            message.append(String.format(" on type '%s'", type));
        }
        if ((source = ((PutMappingRequest)this.request).source()) != null) {
            message.append(String.format(" with source '%s'", source));
        }
        return message.toString();
    }
}

