/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.index;

import org.sonar.api.config.Configuration;
import org.sonar.api.config.internal.MapSettings;
import org.sonar.server.es.Index;
import org.sonar.server.es.IndexDefinition;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.newindex.DefaultIndexSettingsElement;
import org.sonar.server.es.newindex.KeywordFieldBuilder;
import org.sonar.server.es.newindex.NewAuthorizedIndex;
import org.sonar.server.es.newindex.SettingsConfiguration;
import org.sonar.server.es.newindex.TypeMapping;

public class IssueIndexDefinition
implements IndexDefinition {
    public static final Index DESCRIPTOR = Index.withRelations("issues");
    public static final IndexType.IndexRelationType TYPE_ISSUE = IndexType.relation(IndexType.main(DESCRIPTOR, "auth"), "issue");
    public static final String FIELD_ISSUE_ASSIGNEE_UUID = "assignee";
    public static final String FIELD_ISSUE_AUTHOR_LOGIN = "authorLogin";
    public static final String FIELD_ISSUE_COMPONENT_UUID = "component";
    public static final String FIELD_ISSUE_EFFORT = "effort";
    public static final String FIELD_ISSUE_FILE_PATH = "filePath";
    public static final String FIELD_ISSUE_FUNC_CREATED_AT = "issueCreatedAt";
    public static final String FIELD_ISSUE_FUNC_UPDATED_AT = "issueUpdatedAt";
    public static final String FIELD_ISSUE_FUNC_CLOSED_AT = "issueClosedAt";
    public static final String FIELD_ISSUE_KEY = "key";
    public static final String FIELD_ISSUE_LANGUAGE = "language";
    public static final String FIELD_ISSUE_LINE = "line";
    public static final String FIELD_ISSUE_MODULE_UUID = "module";
    public static final String FIELD_ISSUE_MODULE_PATH = "modulePath";
    public static final String FIELD_ISSUE_ORGANIZATION_UUID = "organization";
    public static final String FIELD_ISSUE_PROJECT_UUID = "project";
    public static final String FIELD_ISSUE_BRANCH_UUID = "branch";
    public static final String FIELD_ISSUE_IS_MAIN_BRANCH = "isMainBranch";
    public static final String FIELD_ISSUE_DIRECTORY_PATH = "dirPath";
    public static final String FIELD_ISSUE_RESOLUTION = "resolution";
    public static final String FIELD_ISSUE_RULE_ID = "ruleId";
    public static final String FIELD_ISSUE_SEVERITY = "severity";
    public static final String FIELD_ISSUE_SEVERITY_VALUE = "severityValue";
    public static final String FIELD_ISSUE_STATUS = "status";
    public static final String FIELD_ISSUE_TAGS = "tags";
    public static final String FIELD_ISSUE_TYPE = "type";
    public static final String FIELD_ISSUE_OWASP_TOP_10 = "owaspTop10";
    public static final String FIELD_ISSUE_SANS_TOP_25 = "sansTop25";
    public static final String FIELD_ISSUE_CWE = "cwe";
    private final Configuration config;
    private final boolean enableSource;

    public IssueIndexDefinition(Configuration config) {
        this(config, false);
    }

    private IssueIndexDefinition(Configuration config, boolean enableSource) {
        this.config = config;
        this.enableSource = enableSource;
    }

    public static IssueIndexDefinition createForTest() {
        return new IssueIndexDefinition(new MapSettings().asConfig(), true);
    }

    @Override
    public void define(IndexDefinition.IndexDefinitionContext context) {
        NewAuthorizedIndex index = (NewAuthorizedIndex)context.createWithAuthorization(DESCRIPTOR, SettingsConfiguration.newBuilder(this.config).setRefreshInterval(-1).setDefaultNbOfShards(5).build()).setEnableSource(this.enableSource);
        TypeMapping mapping = index.createTypeMapping(TYPE_ISSUE);
        ((KeywordFieldBuilder)((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_ASSIGNEE_UUID).disableNorms()).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_AUTHOR_LOGIN).disableNorms()).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_COMPONENT_UUID).disableNorms()).build();
        mapping.createLongField(FIELD_ISSUE_EFFORT);
        ((KeywordFieldBuilder)((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_FILE_PATH).disableNorms()).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        mapping.createDateTimeField(FIELD_ISSUE_FUNC_CREATED_AT);
        mapping.createDateTimeField(FIELD_ISSUE_FUNC_UPDATED_AT);
        mapping.createDateTimeField(FIELD_ISSUE_FUNC_CLOSED_AT);
        ((KeywordFieldBuilder)((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_KEY).disableNorms()).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_LANGUAGE).disableNorms()).build();
        mapping.createIntegerField(FIELD_ISSUE_LINE);
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_MODULE_UUID).disableNorms()).build();
        mapping.createUuidPathField(FIELD_ISSUE_MODULE_PATH);
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_ORGANIZATION_UUID).disableNorms()).build();
        ((KeywordFieldBuilder)((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_PROJECT_UUID).disableNorms()).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_BRANCH_UUID).disableNorms()).build();
        mapping.createBooleanField(FIELD_ISSUE_IS_MAIN_BRANCH);
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_DIRECTORY_PATH).disableNorms()).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_RESOLUTION).disableNorms()).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_RULE_ID).disableNorms()).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_SEVERITY).disableNorms()).build();
        mapping.createByteField(FIELD_ISSUE_SEVERITY_VALUE);
        ((KeywordFieldBuilder)((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_STATUS).disableNorms()).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_TAGS).disableNorms()).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_TYPE).disableNorms()).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_OWASP_TOP_10).disableNorms()).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_SANS_TOP_25).disableNorms()).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ISSUE_CWE).disableNorms()).build();
    }
}

