/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.index;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.DateUtils;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.ResultSetIterator;
import org.sonar.server.issue.index.IssueDoc;
import org.sonar.server.issue.index.IssueIterator;
import org.sonar.server.issue.index.SecurityStandardHelper;

class IssueIteratorForSingleChunk
implements IssueIterator {
    private static final String[] FIELDS = new String[]{"i.kee", "i.assignee", "i.line", "i.resolution", "i.severity", "i.status", "i.effort", "i.author_login", "i.issue_close_date", "i.issue_creation_date", "i.issue_update_date", "r.id", "r.language", "c.uuid", "c.module_uuid_path", "c.path", "c.scope", "c.organization_uuid", "c.project_uuid", "c.main_branch_project_uuid", "i.tags", "i.issue_type", "r.security_standards"};
    private static final String SQL_ALL = "select " + StringUtils.join((Object[])FIELDS, (String)",") + " from issues i inner join rules r on r.id = i.rule_id inner join projects c on c.uuid = i.component_uuid ";
    private static final String PROJECT_FILTER = " and c.project_uuid = ? and i.project_uuid = ? ";
    private static final String ISSUE_KEY_FILTER_PREFIX = " and i.kee in (";
    private static final String ISSUE_KEY_FILTER_SUFFIX = ")";
    static final Splitter TAGS_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    static final Splitter MODULE_PATH_SPLITTER = Splitter.on((char)'.').trimResults().omitEmptyStrings();
    private final DbSession session;
    @CheckForNull
    private final String projectUuid;
    @CheckForNull
    private final Collection<String> issueKeys;
    private final PreparedStatement stmt;
    private final ResultSetIterator<IssueDoc> iterator;

    IssueIteratorForSingleChunk(DbClient dbClient, @Nullable String projectUuid, @Nullable Collection<String> issueKeys) {
        Preconditions.checkArgument((issueKeys == null || issueKeys.size() <= 1000 ? 1 : 0) != 0, (Object)"Cannot search for more than 1000 issue keys at once. Please provide the keys in smaller chunks.");
        this.projectUuid = projectUuid;
        this.issueKeys = issueKeys;
        this.session = dbClient.openSession(false);
        try {
            String sql = this.createSql();
            this.stmt = dbClient.getMyBatis().newScrollingSelectStatement(this.session, sql);
            this.iterator = this.createIterator();
        }
        catch (Exception e) {
            this.session.close();
            throw new IllegalStateException("Fail to prepare SQL request to select all issues", e);
        }
    }

    private IssueIteratorInternal createIterator() {
        try {
            this.setParameters(this.stmt);
            return new IssueIteratorInternal(this.stmt);
        }
        catch (SQLException e) {
            DatabaseUtils.closeQuietly((Statement)this.stmt);
            throw new IllegalStateException("Fail to prepare SQL request to select all issues", e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public IssueDoc next() {
        return (IssueDoc)this.iterator.next();
    }

    private String createSql() {
        String sql = SQL_ALL;
        sql = sql + (this.projectUuid == null ? "" : PROJECT_FILTER);
        if (this.issueKeys != null && !this.issueKeys.isEmpty()) {
            sql = sql + ISSUE_KEY_FILTER_PREFIX;
            sql = sql + IntStream.range(0, this.issueKeys.size()).mapToObj(i -> "?").collect(Collectors.joining(","));
            sql = sql + ISSUE_KEY_FILTER_SUFFIX;
        }
        return sql;
    }

    private void setParameters(PreparedStatement stmt) throws SQLException {
        int index = 1;
        if (this.projectUuid != null) {
            stmt.setString(index, this.projectUuid);
            stmt.setString(++index, this.projectUuid);
            ++index;
        }
        if (this.issueKeys != null) {
            for (String key : this.issueKeys) {
                stmt.setString(index, key);
                ++index;
            }
        }
    }

    @Override
    public void close() {
        try {
            this.iterator.close();
        }
        finally {
            DatabaseUtils.closeQuietly((Statement)this.stmt);
            this.session.close();
        }
    }

    private static final class IssueIteratorInternal
    extends ResultSetIterator<IssueDoc> {
        public IssueIteratorInternal(PreparedStatement stmt) throws SQLException {
            super(stmt);
        }

        protected IssueDoc read(ResultSet rs) throws SQLException {
            IssueDoc doc = new IssueDoc(Maps.newHashMapWithExpectedSize((int)30));
            String key = rs.getString(1);
            doc.setKey(key);
            doc.setAssigneeUuid(rs.getString(2));
            doc.setLine(DatabaseUtils.getInt((ResultSet)rs, (int)3));
            doc.setResolution(rs.getString(4));
            doc.setSeverity(rs.getString(5));
            doc.setStatus(rs.getString(6));
            doc.setEffort(DatabaseUtils.getLong((ResultSet)rs, (int)7));
            doc.setAuthorLogin(rs.getString(8));
            doc.setFuncCloseDate(DateUtils.longToDate((Long)DatabaseUtils.getLong((ResultSet)rs, (int)9)));
            doc.setFuncCreationDate(DateUtils.longToDate((Long)DatabaseUtils.getLong((ResultSet)rs, (int)10)));
            doc.setFuncUpdateDate(DateUtils.longToDate((Long)DatabaseUtils.getLong((ResultSet)rs, (int)11)));
            Integer ruleId = rs.getInt(12);
            doc.setRuleId(ruleId);
            doc.setLanguage(rs.getString(13));
            doc.setComponentUuid(rs.getString(14));
            String moduleUuidPath = rs.getString(15);
            doc.setModuleUuid(IssueIteratorInternal.extractModule(moduleUuidPath));
            doc.setModuleUuidPath(moduleUuidPath);
            String scope = rs.getString(17);
            String filePath = IssueIteratorInternal.extractFilePath(rs.getString(16), scope);
            doc.setFilePath(filePath);
            doc.setDirectoryPath(IssueIteratorInternal.extractDirPath(doc.filePath(), scope));
            doc.setOrganizationUuid(rs.getString(18));
            String branchUuid = rs.getString(19);
            String mainBranchProjectUuid = DatabaseUtils.getString((ResultSet)rs, (int)20);
            doc.setBranchUuid(branchUuid);
            if (mainBranchProjectUuid == null) {
                doc.setProjectUuid(branchUuid);
                doc.setIsMainBranch(true);
            } else {
                doc.setProjectUuid(mainBranchProjectUuid);
                doc.setIsMainBranch(false);
            }
            String tags = rs.getString(21);
            doc.setTags(TAGS_SPLITTER.splitToList((CharSequence)(tags == null ? "" : tags)));
            doc.setType(RuleType.valueOf((int)rs.getInt(22)));
            String securityStandards = rs.getString(23);
            List<String> standards = SecurityStandardHelper.getSecurityStandards(securityStandards);
            doc.setOwaspTop10(SecurityStandardHelper.getOwaspTop10(standards));
            List<String> cwe = SecurityStandardHelper.getCwe(standards);
            doc.setCwe(cwe);
            doc.setSansTop25(SecurityStandardHelper.getSansTop25(cwe));
            return doc;
        }

        @CheckForNull
        private static String extractDirPath(@Nullable String filePath, String scope) {
            if (filePath != null) {
                if ("DIR".equals(scope)) {
                    return filePath;
                }
                int lastSlashIndex = CharMatcher.anyOf((CharSequence)"/").lastIndexIn((CharSequence)filePath);
                if (lastSlashIndex > 0) {
                    return filePath.substring(0, lastSlashIndex);
                }
                return "/";
            }
            return null;
        }

        @CheckForNull
        private static String extractFilePath(@Nullable String filePath, String scope) {
            if (filePath != null && !"PRJ".equals(scope)) {
                return filePath;
            }
            return null;
        }

        private static String extractModule(String moduleUuidPath) {
            return (String)Iterators.getLast(MODULE_PATH_SPLITTER.split((CharSequence)moduleUuidPath).iterator());
        }
    }
}

