/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.Duration;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.server.issue.notification.DistributedMetricStatsInt;
import org.sonar.server.issue.notification.MetricStatsLong;

public class NewIssuesStatistics {
    private final Predicate<DefaultIssue> onLeakPredicate;
    private final Map<String, Stats> assigneesStatistics = new LinkedHashMap<String, Stats>();
    private final Stats globalStatistics;

    public NewIssuesStatistics(Predicate<DefaultIssue> onLeakPredicate) {
        this.onLeakPredicate = onLeakPredicate;
        this.globalStatistics = new Stats(onLeakPredicate);
    }

    public void add(DefaultIssue issue) {
        this.globalStatistics.add(issue);
        String userUuid = issue.assignee();
        if (userUuid != null) {
            this.assigneesStatistics.computeIfAbsent(userUuid, a -> new Stats(this.onLeakPredicate)).add(issue);
        }
    }

    public Map<String, Stats> getAssigneesStatistics() {
        return this.assigneesStatistics;
    }

    public Stats globalStatistics() {
        return this.globalStatistics;
    }

    public boolean hasIssues() {
        return this.globalStatistics.hasIssues();
    }

    public boolean hasIssuesOnLeak() {
        return this.globalStatistics.hasIssuesOnLeak();
    }

    public String toString() {
        return "NewIssuesStatistics{assigneesStatistics=" + this.assigneesStatistics + ", globalStatistics=" + this.globalStatistics + '}';
    }

    public static class Stats {
        private final Predicate<DefaultIssue> onLeakPredicate;
        private final Map<Metric, DistributedMetricStatsInt> distributions = new EnumMap<Metric, DistributedMetricStatsInt>(Metric.class);
        private MetricStatsLong effortStats = new MetricStatsLong();

        public Stats(Predicate<DefaultIssue> onLeakPredicate) {
            this.onLeakPredicate = onLeakPredicate;
            for (Metric metric : Metric.values()) {
                if (!metric.isComputedByDistribution()) continue;
                this.distributions.put(metric, new DistributedMetricStatsInt());
            }
        }

        public void add(DefaultIssue issue) {
            String assigneeUuid;
            RuleKey ruleKey;
            boolean isOnLeak = this.onLeakPredicate.test(issue);
            this.distributions.get((Object)Metric.RULE_TYPE).increment(issue.type().name(), isOnLeak);
            String componentUuid = issue.componentUuid();
            if (componentUuid != null) {
                this.distributions.get((Object)Metric.COMPONENT).increment(componentUuid, isOnLeak);
            }
            if ((ruleKey = issue.ruleKey()) != null) {
                this.distributions.get((Object)Metric.RULE).increment(ruleKey.toString(), isOnLeak);
            }
            if ((assigneeUuid = issue.assignee()) != null) {
                this.distributions.get((Object)Metric.ASSIGNEE).increment(assigneeUuid, isOnLeak);
            }
            for (String tag : issue.tags()) {
                this.distributions.get((Object)Metric.TAG).increment(tag, isOnLeak);
            }
            Duration effort = issue.effort();
            if (effort != null) {
                this.effortStats.add(effort.toMinutes(), isOnLeak);
            }
        }

        public DistributedMetricStatsInt getDistributedMetricStats(Metric metric) {
            return this.distributions.get((Object)metric);
        }

        public MetricStatsLong effort() {
            return this.effortStats;
        }

        public boolean hasIssues() {
            return this.getDistributedMetricStats(Metric.RULE_TYPE).getTotal() > 0;
        }

        public boolean hasIssuesOnLeak() {
            return this.getDistributedMetricStats(Metric.RULE_TYPE).getOnLeak() > 0;
        }

        public String toString() {
            return "Stats{distributions=" + this.distributions + ", effortStats=" + this.effortStats + '}';
        }
    }

    public static enum Metric {
        RULE_TYPE(true),
        TAG(true),
        COMPONENT(true),
        ASSIGNEE(true),
        EFFORT(false),
        RULE(true);

        private final boolean isComputedByDistribution;

        private Metric(boolean isComputedByDistribution) {
            this.isComputedByDistribution = isComputedByDistribution;
        }

        boolean isComputedByDistribution() {
            return this.isComputedByDistribution;
        }
    }
}

