/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.workflow;

import com.google.common.base.Preconditions;
import java.util.List;
import org.picocontainer.Startable;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.issue.Issue;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ServerSide;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.server.issue.IssueFieldsSetter;
import org.sonar.server.issue.workflow.FunctionExecutor;
import org.sonar.server.issue.workflow.HasResolution;
import org.sonar.server.issue.workflow.HasType;
import org.sonar.server.issue.workflow.IsBeingClosed;
import org.sonar.server.issue.workflow.IsManualVulnerability;
import org.sonar.server.issue.workflow.IsNotHotspotNorManualVulnerability;
import org.sonar.server.issue.workflow.NotCondition;
import org.sonar.server.issue.workflow.PreviousStatusWas;
import org.sonar.server.issue.workflow.RestoreResolutionFunction;
import org.sonar.server.issue.workflow.SetCloseDate;
import org.sonar.server.issue.workflow.SetClosed;
import org.sonar.server.issue.workflow.SetResolution;
import org.sonar.server.issue.workflow.SetType;
import org.sonar.server.issue.workflow.State;
import org.sonar.server.issue.workflow.StateMachine;
import org.sonar.server.issue.workflow.Transition;
import org.sonar.server.issue.workflow.UnsetAssignee;
import org.sonar.server.issue.workflow.UnsetCloseDate;

@ServerSide
@ComputeEngineSide
public class IssueWorkflow
implements Startable {
    private static final String AUTOMATIC_CLOSE_TRANSITION = "automaticclose";
    private final FunctionExecutor functionExecutor;
    private final IssueFieldsSetter updater;
    private StateMachine machine;

    public IssueWorkflow(FunctionExecutor functionExecutor, IssueFieldsSetter updater) {
        this.functionExecutor = functionExecutor;
        this.updater = updater;
    }

    public void start() {
        StateMachine.Builder builder = StateMachine.builder().states("OPEN", "CONFIRMED", "REOPENED", "RESOLVED", "CLOSED");
        IssueWorkflow.buildManualTransitions(builder);
        IssueWorkflow.buildAutomaticTransitions(builder);
        IssueWorkflow.buildSecurityHotspotTransitions(builder);
        this.machine = builder.build();
    }

    private static void buildManualTransitions(StateMachine.Builder builder) {
        builder.transition(Transition.builder("confirm").from("OPEN").to("CONFIRMED").conditions(IsNotHotspotNorManualVulnerability.INSTANCE).functions(new SetResolution(null)).build()).transition(Transition.builder("confirm").from("REOPENED").to("CONFIRMED").conditions(IsNotHotspotNorManualVulnerability.INSTANCE).functions(new SetResolution(null)).build()).transition(Transition.builder("unconfirm").from("CONFIRMED").to("REOPENED").conditions(IsNotHotspotNorManualVulnerability.INSTANCE).functions(new SetResolution(null)).build()).transition(Transition.builder("resolve").from("OPEN").to("RESOLVED").conditions(IsNotHotspotNorManualVulnerability.INSTANCE).functions(new SetResolution("FIXED")).build()).transition(Transition.builder("resolve").from("REOPENED").to("RESOLVED").conditions(IsNotHotspotNorManualVulnerability.INSTANCE).functions(new SetResolution("FIXED")).build()).transition(Transition.builder("resolve").from("CONFIRMED").to("RESOLVED").conditions(IsNotHotspotNorManualVulnerability.INSTANCE).functions(new SetResolution("FIXED")).build()).transition(Transition.builder("reopen").from("RESOLVED").to("REOPENED").conditions(IsNotHotspotNorManualVulnerability.INSTANCE).functions(new SetResolution(null)).build()).transition(Transition.builder("falsepositive").from("OPEN").to("RESOLVED").conditions(IsNotHotspotNorManualVulnerability.INSTANCE).functions(new SetResolution("FALSE-POSITIVE"), UnsetAssignee.INSTANCE).requiredProjectPermission("issueadmin").build()).transition(Transition.builder("falsepositive").from("REOPENED").to("RESOLVED").conditions(IsNotHotspotNorManualVulnerability.INSTANCE).functions(new SetResolution("FALSE-POSITIVE"), UnsetAssignee.INSTANCE).requiredProjectPermission("issueadmin").build()).transition(Transition.builder("falsepositive").from("CONFIRMED").to("RESOLVED").conditions(IsNotHotspotNorManualVulnerability.INSTANCE).functions(new SetResolution("FALSE-POSITIVE"), UnsetAssignee.INSTANCE).requiredProjectPermission("issueadmin").build()).transition(Transition.builder("wontfix").from("OPEN").to("RESOLVED").conditions(IsNotHotspotNorManualVulnerability.INSTANCE).functions(new SetResolution("WONTFIX"), UnsetAssignee.INSTANCE).requiredProjectPermission("issueadmin").build()).transition(Transition.builder("wontfix").from("REOPENED").to("RESOLVED").conditions(IsNotHotspotNorManualVulnerability.INSTANCE).functions(new SetResolution("WONTFIX"), UnsetAssignee.INSTANCE).requiredProjectPermission("issueadmin").build()).transition(Transition.builder("wontfix").from("CONFIRMED").to("RESOLVED").conditions(IsNotHotspotNorManualVulnerability.INSTANCE).functions(new SetResolution("WONTFIX"), UnsetAssignee.INSTANCE).requiredProjectPermission("issueadmin").build());
    }

    private static void buildSecurityHotspotTransitions(StateMachine.Builder builder) {
        builder.transition(Transition.builder("detect").from("OPEN").to("OPEN").conditions(new HasType(RuleType.SECURITY_HOTSPOT, new RuleType[0])).functions(new SetType(RuleType.VULNERABILITY)).requiredProjectPermission("securityhotspotadmin").build()).transition(Transition.builder("detect").from("REOPENED").to("OPEN").conditions(new HasType(RuleType.SECURITY_HOTSPOT, new RuleType[0])).functions(new SetType(RuleType.VULNERABILITY)).requiredProjectPermission("securityhotspotadmin").build()).transition(Transition.builder("detect").from("RESOLVED").to("OPEN").conditions(new HasType(RuleType.SECURITY_HOTSPOT, new RuleType[0]), new HasResolution("WONTFIX", new String[0])).functions(new SetType(RuleType.VULNERABILITY), new SetResolution(null)).requiredProjectPermission("securityhotspotadmin").build()).transition(Transition.builder("dismiss").from("OPEN").to("REOPENED").conditions(IsManualVulnerability.INSTANCE).functions(new SetType(RuleType.SECURITY_HOTSPOT)).requiredProjectPermission("securityhotspotadmin").build()).transition(Transition.builder("requestreview").from("OPEN").to("RESOLVED").conditions(IsManualVulnerability.INSTANCE).functions(new SetType(RuleType.SECURITY_HOTSPOT), new SetResolution("FIXED")).build()).transition(Transition.builder("requestreview").from("REOPENED").to("RESOLVED").conditions(IsManualVulnerability.INSTANCE).functions(new SetType(RuleType.SECURITY_HOTSPOT), new SetResolution("FIXED")).build()).transition(Transition.builder("reject").from("RESOLVED").to("REOPENED").conditions(new HasType(RuleType.SECURITY_HOTSPOT, new RuleType[0]), new HasResolution("FIXED", new String[0])).functions(new SetType(RuleType.VULNERABILITY), new SetResolution(null)).requiredProjectPermission("securityhotspotadmin").build()).transition(Transition.builder("accept").from("RESOLVED").to("RESOLVED").conditions(new HasType(RuleType.SECURITY_HOTSPOT, new RuleType[0]), new HasResolution("FIXED", new String[0])).functions(new SetResolution("WONTFIX")).requiredProjectPermission("securityhotspotadmin").build()).transition(Transition.builder("clear").from("OPEN").to("RESOLVED").conditions(new HasType(RuleType.SECURITY_HOTSPOT, new RuleType[0])).functions(new SetResolution("WONTFIX")).requiredProjectPermission("securityhotspotadmin").build()).transition(Transition.builder("clear").from("REOPENED").to("RESOLVED").conditions(new HasType(RuleType.SECURITY_HOTSPOT, new RuleType[0])).functions(new SetResolution("WONTFIX")).requiredProjectPermission("securityhotspotadmin").build()).transition(Transition.builder("reopenhotspot").from("RESOLVED").to("REOPENED").conditions(new HasType(RuleType.SECURITY_HOTSPOT, new RuleType[0]), new HasResolution("WONTFIX", new String[0])).functions(new SetResolution(null)).requiredProjectPermission("securityhotspotadmin").build());
    }

    private static void buildAutomaticTransitions(StateMachine.Builder builder) {
        builder.transition(Transition.builder(AUTOMATIC_CLOSE_TRANSITION).from("OPEN").to("CLOSED").conditions(IsBeingClosed.INSTANCE).functions(SetClosed.INSTANCE, SetCloseDate.INSTANCE).automatic().build()).transition(Transition.builder(AUTOMATIC_CLOSE_TRANSITION).from("REOPENED").to("CLOSED").conditions(IsBeingClosed.INSTANCE).functions(SetClosed.INSTANCE, SetCloseDate.INSTANCE).automatic().build()).transition(Transition.builder(AUTOMATIC_CLOSE_TRANSITION).from("CONFIRMED").to("CLOSED").conditions(IsBeingClosed.INSTANCE).functions(SetClosed.INSTANCE, SetCloseDate.INSTANCE).automatic().build()).transition(Transition.builder(AUTOMATIC_CLOSE_TRANSITION).from("RESOLVED").to("CLOSED").conditions(IsBeingClosed.INSTANCE).functions(SetClosed.INSTANCE, SetCloseDate.INSTANCE).automatic().build()).transition(Transition.builder("automaticreopen").from("RESOLVED").to("REOPENED").conditions(new NotCondition(IsBeingClosed.INSTANCE), new HasResolution("FIXED", new String[0]), IsNotHotspotNorManualVulnerability.INSTANCE).functions(new SetResolution(null), UnsetCloseDate.INSTANCE).automatic().build()).transition(Transition.builder("automaticuncloseopen").from("CLOSED").to("OPEN").conditions(new PreviousStatusWas("OPEN"), new HasResolution("REMOVED", "FIXED"), IsNotHotspotNorManualVulnerability.INSTANCE).functions(RestoreResolutionFunction.INSTANCE, UnsetCloseDate.INSTANCE).automatic().build()).transition(Transition.builder("automaticunclosereopen").from("CLOSED").to("REOPENED").conditions(new PreviousStatusWas("REOPENED"), new HasResolution("REMOVED", "FIXED"), IsNotHotspotNorManualVulnerability.INSTANCE).functions(RestoreResolutionFunction.INSTANCE, UnsetCloseDate.INSTANCE).automatic().build()).transition(Transition.builder("automaticuncloseconfirmed").from("CLOSED").to("CONFIRMED").conditions(new PreviousStatusWas("CONFIRMED"), new HasResolution("REMOVED", "FIXED"), IsNotHotspotNorManualVulnerability.INSTANCE).functions(RestoreResolutionFunction.INSTANCE, UnsetCloseDate.INSTANCE).automatic().build()).transition(Transition.builder("automaticuncloseresolved").from("CLOSED").to("RESOLVED").conditions(new PreviousStatusWas("RESOLVED"), new HasResolution("REMOVED", "FIXED"), IsNotHotspotNorManualVulnerability.INSTANCE).functions(RestoreResolutionFunction.INSTANCE, UnsetCloseDate.INSTANCE).automatic().build());
    }

    public void stop() {
    }

    public boolean doManualTransition(DefaultIssue issue, String transitionKey, IssueChangeContext issueChangeContext) {
        Transition transition = this.stateOf(issue).transition(transitionKey);
        if (!transition.automatic()) {
            this.functionExecutor.execute(transition.functions(), issue, issueChangeContext);
            this.updater.setStatus(issue, transition.to(), issueChangeContext);
            return true;
        }
        return false;
    }

    public List<Transition> outTransitions(Issue issue) {
        String status = issue.status();
        State state = this.machine.state(status);
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (String)"Unknown status: %s", (Object[])new Object[]{status});
        return state.outManualTransitions(issue);
    }

    public void doAutomaticTransition(DefaultIssue issue, IssueChangeContext issueChangeContext) {
        Transition transition = this.stateOf(issue).outAutomaticTransition((Issue)issue);
        if (transition != null) {
            this.functionExecutor.execute(transition.functions(), issue, issueChangeContext);
            this.updater.setStatus(issue, transition.to(), issueChangeContext);
        }
    }

    public List<String> statusKeys() {
        return this.machine.stateKeys();
    }

    private State stateOf(DefaultIssue issue) {
        String status = issue.status();
        State state = this.machine.state(status);
        String issueKey = issue.key();
        Preconditions.checkState((state != null ? 1 : 0) != 0, (String)"Unknown status: %s [issue=%s]", (Object[])new Object[]{status, issueKey});
        return state;
    }

    StateMachine machine() {
        return this.machine;
    }
}

