/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.notification;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.ExtensionPoint;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.notifications.Notification;
import org.sonar.api.notifications.NotificationChannel;
import org.sonar.api.server.ServerSide;

@ServerSide
@ComputeEngineSide
@ExtensionPoint
public abstract class NotificationDispatcher {
    private final String notificationType;

    public NotificationDispatcher(String notificationType) {
        this.notificationType = notificationType;
    }

    public NotificationDispatcher() {
        this("");
    }

    public String getKey() {
        return this.getClass().getSimpleName();
    }

    public String getType() {
        return this.notificationType;
    }

    public final void performDispatch(Notification notification, Context context) {
        if (StringUtils.equals((String)notification.getType(), (String)this.notificationType) || StringUtils.equals((String)"", (String)this.notificationType)) {
            this.dispatch(notification, context);
        }
    }

    public abstract void dispatch(Notification var1, Context var2);

    public String toString() {
        return this.getKey();
    }

    public static interface Context {
        public void addUser(String var1, NotificationChannel var2);
    }
}

