/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization;

import java.util.Objects;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.MessageException;

@ComputeEngineSide
@ServerSide
public interface BillingValidations {
    public void checkBeforeProjectAnalysis(Organization var1);

    public void checkCanUpdateProjectVisibility(Organization var1, boolean var2);

    public boolean canUpdateProjectVisibilityToPrivate(Organization var1);

    public void onDelete(Organization var1);

    public static class BillingValidationsException
    extends MessageException {
        public BillingValidationsException(String message) {
            super(message);
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        public String toString() {
            return this.getMessage();
        }
    }

    public static class Organization {
        private final String key;
        private final String uuid;
        private final String name;

        public Organization(String key, String uuid, String name) {
            this.key = Objects.requireNonNull(key, "Organization key cannot be null");
            this.uuid = Objects.requireNonNull(uuid, "Organization uuid cannot be null");
            this.name = Objects.requireNonNull(name, "Organization name cannot be null");
        }

        public String getKey() {
            return this.key;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }
    }
}

